% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_psoho.R
\name{Position}
\alias{Position}
\title{R6 class that defines DBNs as causality lists}
\arguments{
\item{vl}{a Velocity object}

\item{ps}{a Position object
return the Velocity that gets this position to the new one}

\item{nodes}{a character vector with the names of the nodes in the net}

\item{size}{the desired size of the DBN}

\item{net}{the DBN structure}

\item{nodes_t_0}{a vector with the names of the nodes in t_0}
}
\value{
A new 'causlist' object

a dbn object

the ordering of the nodes in t_0

a causlist object

a random dbn structure

the fixed network
}
\description{
Constructor of the 'causlist' class

Translate the causality list into a DBN network

Uses this object private causality list and transforms it into a DBN.

Add a velocity to the position

Given a Velocity object, add it to the current position.

Given another position, returns the velocity that gets this position to the
other.

Return the static node ordering

This function takes as input a dbn and return the node ordering of the
variables inside a timeslice. This ordering is needed to understand a
causal list.

Translate a DBN into a causality list

This function takes as input a network from a DBN and transforms the 
structure into a causality list if it is a valid DBN. Valid DBNs have only
inter-timeslice edges and only allow variables in t_0 to have parents.

Generates a random DBN valid for causality list translation

This function takes as input a list with the names of the nodes and the
desired size of the network and returns a random DBN structure.

Fixes a DBN structure to make it suitable for causality list translation

This function takes as input a DBN structure and removes the 
intra-timeslice arcs and the arcs that end in a node not in t_0.
}
\details{
A causality list has a list with causal units, a size representing the
Markovian order of the network and a specific node ordering.
}
\section{Fields}{

\describe{
\item{\code{n_arcs}}{Number of arcs in the network}

\item{\code{nodes}}{Names of the nodes in the network}
}}

\keyword{internal}
