% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{parse_drug_salts}
\alias{parse_drug_salts}
\title{Extracts the drug salts and return data as tibble.}
\usage{
parse_drug_salts(save_table = FALSE)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}
}
\value{
drug salts node attributes tibble
}
\description{
\code{parse_drug_salts} returns tibble of drug products elements.
}
\details{
This functions extracts the salts element of drug node in drugbank
xml database with the option to save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
save the returned tibble in the database.
It must be called after \code{\link{get_xml_db_rows}} function like
any other parser function.
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\donttest{
parse_drug_salts()
parse_drug_salts(TRUE)
parse_drug_salts(save_table = FALSE)
}
}
