% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{in_schema}
\alias{in_schema}
\alias{in_catalog}
\title{Refer to a table in a schema or a database catalog}
\usage{
in_schema(schema, table)

in_catalog(catalog, schema, table)
}
\arguments{
\item{catalog, schema, table}{Names of catalog, schema, and table.
These will be automatically quoted; use \code{\link[=sql]{sql()}} to pass a raw name
that won't get quoted.}
}
\description{
\code{in_schema()} can be used in \code{\link[=tbl]{tbl()}} to indicate a table in a specific
schema.
\code{in_catalog()} additionally allows specifying the database catalog.
}
\examples{
in_schema("my_schema", "my_table")
in_catalog("my_catalog", "my_schema", "my_table")
# eliminate quotes
in_schema(sql("my_schema"), sql("my_table"))

# Example using schemas with SQLite
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# Add auxiliary schema
tmp <- tempfile()
DBI::dbExecute(con, paste0("ATTACH '", tmp, "' AS aux"))

library(dplyr, warn.conflicts = FALSE)
copy_to(con, iris, "df", temporary = FALSE)
copy_to(con, mtcars, in_schema("aux", "df"), temporary = FALSE)

con \%>\% tbl("df")
con \%>\% tbl(in_schema("aux", "df"))
}
