% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{dbxConnect}
\alias{dbxConnect}
\title{Create a database connection}
\usage{
dbxConnect(url = NULL, adapter = NULL, storage_tz = NULL,
  variables = list(), ...)
}
\arguments{
\item{url}{A database URL}

\item{adapter}{The database adapter to use}

\item{storage_tz}{The time zone timestamps are stored in}

\item{variables}{Session variables}

\item{...}{Arguments to pass to dbConnect}
}
\description{
Create a database connection
}
\examples{
# SQLite
db <- dbxConnect(adapter="sqlite", dbname=":memory:")

\dontrun{

# Postgres
db <- dbxConnect(adapter="postgres", dbname="mydb")

# MySQL
db <- dbxConnect(adapter="mysql", dbname="mydb")

# Others
db <- dbxConnect(adapter=odbc(), database="mydb")
}
}
