<a href="index.html"><IMG src="dcGOR_logo.png" height="100px" id="logo"></a>

<B><h4>An open-source <a href="http://www.r-project.org" target="R" style="font-size: 12px; color: #4169E1; text-decoration: overline; border-bottom: 1px solid #4169E1">R</a> package for analysing domain-centric ontologies and annotations (<a href="http://supfam.org/SUPERFAMILY/dcGO" target="dcGO" style="font-size: 12px; color: #F87217; text-decoration: overline; border-bottom: 1px solid #F87217">dcGO</a> and others)</h4></B>


## Features

* `Database`: R package providing domain-centric annotations by organism-independent ontologies (eg "Gene Ontology") and organism-specific ontologies (eg "Human Phenotype" and "Mammalian Phenotype"). Entities can be domains taken from SCOP (at both the superfamily and family levels), Pfam and InterPro, and also can be domain-like features (eg Rfam RNA families). See <a href="docs.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Documentations</a>
* `Infrastructure`: data structure storing domains (as objects of S4 class <a href="InfoDataFrame-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">InfoDataFrame</a>), annotations (as objects of S4 class <a href="Anno-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Anno</a>), ontologies (as objects of S4 class <a href="Onto-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Onto</a>), enrichment outputs (as objects of S4 class <a href="Eoutput-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Eoutput</a>), domain networks (as objects of S4 class <a href="Dnetwork-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Dnetwork</a>), and RWR-based contact network outputs (as objects of S4 classes <a href="Cnetwork-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Cnetwork</a> and <a href="Coutput-class.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">Coutput</a>)
* `True-path rule`: able to propagate annotations to all ancestor terms. See <a href="dcDAGannotate.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcDAGannotate</a>
* `Enrichment analysis`: domain-based enrichment analysis and visualisation. See <a href="dcEnrichment.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcEnrichment</a> and <a href="visEnrichment.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">visEnrichment</a>
* `Semantic similarity`: semantic similarity between pairs of domains according to their annotations by an ontology, resulting in a domain (semantic similarity) network. See <a href="dcDAGdomainSim.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcDAGdomainSim</a>
* `Random Walk with Restart`: support for walk on a domain network to estimate contact (statistically significance) network.  See <a href="dcRWRpipeline.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcRWRpipeline</a>
* `Parallel computing`: most of analyses are supported with parallel option to reduce runtime
* `Customisation`: user-input data used to build objects for domains (see <a href="dcBuildInfoDataFrame.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcBuildInfoDataFrame</a>), annotations (see <a href="dcBuildAnno.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcBuildAnno</a>) and ontologies (see <a href="dcBuildOnto.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcBuildOnto</a>). Also supported for these customised objects are analyses such as <a href="dcEnrichment.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcEnrichment</a> (also <a href="visEnrichment.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">visEnrichment</a>) and <a href="dcDAGdomainSim.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcDAGdomainSim</a>


## New Functionalities

* `dcGO Algorithm`: functions used for creating domain-centric ontology. See <a href="dcAlgo.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAlgo</a> and <a href="dcAlgoPropagate.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAlgoPropagate</a>
* `dcGO Predictor`: functions and databases used for predicting ontology terms from input protein domain contents. See <a href="dcAlgoPredictMain.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAlgoPredictMain</a> (also <a href="dcAlgoPredict.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAlgoPredict</a>) and <a href="dcAlgoPredictPR.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAlgoPredictPR</a>, and <a href="dcAlgoPredictGenome.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAlgoPredictGenome</a>
* `Ancestral reconstruction`: functions and databases used for reconstructing ancestral states for discrete characters (eg domain architectures across tree of life). See <a href="dcAncestralMP.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAncestralMP</a> and <a href="dcAncestralML.html" style="font-size: 12px; color: #000000; text-decoration: none; border-bottom: 1px solid #000000">dcAncestralML</a>
