% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barChartRace.R
\name{barChartRace}
\alias{barChartRace}
\title{Create a bar chart race.}
\usage{
barChartRace(
  data,
  x,
  y,
  time,
  ease = "Linear",
  frameDur = 500,
  transitionDur = 500,
  colorCategory = "Accent",
  sort = "descending",
  paddingWidth = 0.1,
  xFontSize = 10,
  yFontSize = 10,
  xticks = 10,
  xtitle = NULL,
  xtitleFontSize = 16,
  ytitle = NULL,
  ytitleFontSize = 14,
  title = NULL,
  titleFontSize = 22,
  stroke = "black",
  strokeWidth = NULL,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "#CAD0D3",
  panelcol = "#EBEBEBFF",
  xgridlinecol = "white",
  opacity = 1,
  timeLabel = TRUE,
  timeLabelOpts = list(size = 32, prefix = "", suffix = "", xOffset = 0.5, yOffset = 1),
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{x}{The x-variable to consider.}

\item{y}{The y-variable to consider.}

\item{time}{The time variable to consider.}

\item{ease}{The easing method, you can find more
here <https://github.com/d3/d3-ease>. Defaults to 'Linear'.}

\item{frameDur}{The time spent paused on each frame (time point) in milliseconds.}

\item{transitionDur}{The time spent transitioning between frames in milliseconds.}

\item{colorCategory}{A D3 categorical color scheme, you can find more
here <https://github.com/d3/d3-scale-chromatic#categorical>. Defaults to 'Accent'.}

\item{sort}{Whether to sort or not the bars. Takes three values
'none' which is the default, 'ascending' or 'descending'. Defaults to 'descending'.}

\item{paddingWidth}{The distance between each bar.
The value goes from 0 to 0.99 included. Defaults to 0.1.}

\item{xFontSize}{the font size of the x-axis labels. Defaults to 10.}

\item{yFontSize}{the font size of the y-axis labels. Defaults to 10.}

\item{xticks}{the number of y-axis ticks to consider. Defaults to 10.}

\item{xtitle}{Optional. The title of the x-axis.}

\item{xtitleFontSize}{The font size of the x-axis title. Defaults to 16.}

\item{ytitle}{Optional. The title of the y-axis.}

\item{ytitleFontSize}{The font size of the y-axis title. Defaults to 14.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{stroke}{The stroke color of the bars. Defaults to 'black'.}

\item{strokeWidth}{Optional. the stroke width of the bars.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the SVG. Defaults to "#CAD0D3" HEX color.}

\item{panelcol}{The background color of the panel. Defaults to "#EBEBEBFF" HEX color.}

\item{xgridlinecol}{The color of the x-axis grid lines. Defaults to 'white'.}

\item{opacity}{The color opacity of the bars (from 0 to 1). Defaults to 1.}

\item{timeLabel}{Whether to show a label for the value of the time variable. Defaults to TRUE.}

\item{timeLabelOpts}{Options for labeling the value of the time variable.
Takes a list specifying the `size`, `prefix`, `suffix`, `xOffset`, and `yOffset`.
Offsets are scaled relative to the dimensions of the label, from the bottom-right corner of the panel.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
An animated SVG bar chart race, wrapped in a div.
}
\description{
Create a bar chart race.
}
\examples{
library(gapminder)
library(dplyr)
# let's select a set of countries only
gapminder <- gapminder \%>\%
filter(
country \%in\% c("Algeria", "Mexico", "Iceland", "Greece", "Finland")
)

barChartRace(
data = gapminder,
x = "lifeExp",
y = "country",
time = "year",
ytitle = "Country",
xtitle = "Life expectancy",
title = "Bar chart race of countries life expectancy"
)
}
