% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Power_plants}
\alias{Power_plants}
\title{Data: Tone (2002).}
\format{
Data frame with 15 rows and 7 columns. Definition of inputs (X) and outputs (Y):
\describe{
  \item{x1}{Manpower requiered}
  \item{x2}{Construction costs in millions of dollars}
  \item{x3}{Annual maintenance costs in millions of dollars}
  \item{x4}{Number of villages to be evacuated }
  \item{y1}{Power generated in megawatts}
  \item{y2}{Safety level}
}
}
\source{
Andersen, P.; Petersen, N.C. (1993). "A procedure for ranking efficient
units in data envelopment analysis", Management Science, 39, 1261-1264.

Doyle, J. and Green R. (1993). "Data envelopment analysis and multiple criteria
decision making", Omega, 21 (6), 713-715.  \doi{10.1016/0305-0483(93)90013-B}

Tone, K. (2002). "A slacks-based measure of super-efficiency in data envelopment
analysis", European Journal of Operational Research, 143, 32-41.
\doi{10.1016/S0377-2217(01)00324-1}
}
\usage{
data("Power_plants")
}
\description{
This dataset consists of six power plants with 4 inputs (X) and 2 outputs (Y).
}
\examples{
# Example 1. Radial super-efficiency model.
# Replication of results in Tone (2002)
data("Power_plants")
data_example <- read_data(Power_plants,
                          ni = 4,
                          no = 2)
result <- model_supereff(data_example,
                         orientation = "io",
                         rts = "crs")
eff <- efficiencies(result)
eff

# Example 2. SBM super-efficiency model.
data("Power_plants")
data_example <- read_data(Power_plants,
                          ni = 4,
                          no = 2)
result2 <- model_sbmsupereff(data_example,
                             orientation = "io",
                             rts = "crs")
efficiencies(result2)
slacks(result2)$input
references(result2)

}
\seealso{
\code{\link{read_data}}, \code{\link{model_supereff}},
\code{\link{model_sbmsupereff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
