% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/individualEvpiSimulation.R
\name{individualEvpiSimulation}
\alias{individualEvpiSimulation}
\title{Individual Expected Value of Perfect Information Simulation}
\usage{
individualEvpiSimulation(welfare, currentEstimate,
  perfectProspectiveNames = row.names(currentEstimate),
  perfectProspectiveValues = colMeans(as.data.frame(random(rho =
  currentEstimate, n = numberOfModelRuns, method = randomMethod,
  relativeTolerance = relativeTolerance))[perfectProspectiveNames]),
  numberOfModelRuns, randomMethod = "calculate",
  functionSyntax = "data.frameNames", relativeTolerance = 0.05,
  verbosity = 0)
}
\arguments{
\item{welfare}{either a \code{function} or a \code{list} with two \code{functions}, i.e.
\code{list(p1,p2)}. In the first case the function is the net benefit (or welfare) of project approval (PA) vs.
the status quo (SQ). In the second case the element \code{p1} is the function valuing the first
project and the element \code{p2} valuing the second project, viz. the welfare function of \code{p1}
and \code{p2} respectively.}

\item{currentEstimate}{\code{\link{estimate}}: describing the distribution of the input variables
as currently being estimated.}

\item{perfectProspectiveNames}{\code{character vector}: input variable names that are assumed to be known perfectly with
prospective information.}

\item{perfectProspectiveValues}{\code{numeric vector}: of the same length as \code{perfectProspectiveNames} with the corresponding
values assumed to be known perfectly.}

\item{numberOfModelRuns}{\code{integer}: The number of running the welfare model for the
underlying Monte Carlo simulation.}

\item{randomMethod}{\code{character}: The method to be used to sample the distribution
representing the input estimate. For details see option \code{method} in
\code{\link{random.estimate}}.}

\item{functionSyntax}{\code{character}: function syntax used in the welfare function(s). For
details see \code{\link{mcSimulation}}.}

\item{relativeTolerance}{\code{numeric}: the relative tolerance level of deviation of the
generated confidence interval from the specified interval. If this deviation is greater than
\code{relativeTolerance} a warning is given.}

\item{verbosity}{\code{integer}: if \code{0} the function is silent; the larger the value the
more verbose is output information.}
}
\value{
An object of class \code{eviSimulation} with the following elements:
 \describe{
			\item{\code{$current}}{
			   \code{\link{welfareDecisionAnalysis}} object for \code{currentEstimate}
			}
			\item{\code{$prospective}}{
			  \code{\link{welfareDecisionAnalysis}} object  for single \code{perfectProspectiveNames} or a
			  list of \code{\link{welfareDecisionAnalysis}} objects for several \code{perfectProspectiveNames}.
			}
 		\item{\code{$evi}}{
 		  Expected Value of Information(s) (EVI)(s) gained by the perfect knowledge of individual
 		  variable(s) w.r.t. the current estimate.
 		}
  }
}
\description{
The Individual Expected Value of Perfect Information (Individual EVPI) is calculated based on a
Monte Carlo simulation of the values of two different decision alternatives.
}
\details{
The Individual EVPI is defined as the EVI with respect to a prospective information
that assumes perfect knowledge on one particular variable.
}
\examples{
# Number of running the underlying welfare model:
n=10000
# Create the current estimate from text:
estimateText<-"variable,  distribution, lower, upper
               revenue1,  posnorm,      100,   1000
               revenue2,  posnorm,      50,    2000
               costs1,    posnorm,      50,    2000
               costs2,    posnorm,      100,   1000"
currentEstimate<-as.estimate(read.csv(header=TRUE, text=estimateText,
                          strip.white=TRUE, stringsAsFactors=FALSE))
# The welfare function:
profitModel <- function(x){
 list(Profit=x$revenue1 + x$revenue2 - x$costs1 - x$costs2)
}
# Calculate the Individual EVPI:
individualEvpiResult<-individualEvpiSimulation(welfare=profitModel,
                                               currentEstimate=currentEstimate,
                                               numberOfModelRuns=n,
                                               functionSyntax="data.frameNames")
# Show the simulation results:
print(sort(summary(individualEvpiResult)),decreasing=TRUE,along="Profit")
hist(individualEvpiResult, breaks=100)
}
\seealso{
\code{\link{eviSimulation}}, \code{\link{welfareDecisionAnalysis}}, \code{\link{mcSimulation}}, \code{\link{estimate}}
}

