% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_CPT.R
\name{sample_CPT}
\alias{sample_CPT}
\title{Sample a Conditional Probability Table}
\usage{
sample_CPT(CPT, states)
}
\arguments{
\item{CPT}{list of two data.frames: 1) Conditional Probability Table (CPT); 2) legend table
specifying which states of the parent nodes belong to which column in the CPT. This can
be generated with the make_CPT function, or specified manually (which can be cumbersome).}

\item{states}{character vector containing (in the right sequence) state values for all
parent variables.}
}
\value{
one of the states of the child node belonging to the CPT.
}
\description{
This function randomly chooses a state of a categorical variable, based on a Conditional
Probability Table (CPT; a component of Bayesian Network models) that expresses the probability
of each possible state in relation to the states of other categorical variables. Given
information on the state of all parent variables, the function uses the appropriate
probability distribution to draw a random sample for the state of the variable of interest.
}
\examples{

test_CPT<-make_CPT(parent_effects=list(c(-1,3),c(-4,2),c(-2,3,4),c(1,2,3)),
                  parent_weights=c(1,1,1,1),b=2,child_prior=c(1,2,3,4,5),
                  child_states=c("a","b","c","d","e"),
                  parent_states=list(c("low","high"),c("A","B"),c(1,2,3),
                  c("Left","Right","Center")))

sample_CPT(CPT=test_CPT,states=c("low","A","2","Left"))

}
\author{
Eike Luedeling
}
\keyword{~kwd1}
\keyword{~kwd2}

