% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\alias{as.estimate}
\title{Create a multivariate estimate object.}
\usage{
estimate(distribution, lower, upper, ..., correlation_matrix = NULL)

as.estimate(..., correlation_matrix = NULL)
}
\arguments{
\item{distribution}{\code{character vector}: defining the types of the univariate parametric 
distributions.}

\item{lower}{\code{numeric vector}: lower bounds of the 90\% confidence intervals, i.e the 5\%-quantiles 
of this estimates components.}

\item{upper}{\code{numeric vector}: upper bounds of the 90\% confidence intervals, i.e the 95\%-quantiles
of this estimates components.}

\item{...}{in \code{estimate}: optional arguments that can be coerced to a data frame comprising
further columns of the estimate (for details cf. below).\cr
        in \code{as.estimate}: arguments that can be coerced to a data frame comprising the 
        marginal distributions of the estimate components. Mandatory columns are \code{distribution}, \code{lower} and 
        \code{upper}.}

\item{correlation_matrix}{\code{numeric matrix}: containing the correlations of the variables 
(optional).}
}
\value{
An object of class \code{estimate} which is a list with components \code{$marginal} and 
\code{$correlation_matrix}:
  \describe{
    \item{\code{$marginal}}{
    is a \code{\link{data.frame}} with mandatory columns:  
    \tabular{lll}{
      \bold{Mandatory column}      \tab  \bold{R-type}                 \tab \bold{Explanation}\cr
      \code{distribution} \tab  \code{character vector} \tab  Distribution types \cr
      \code{lower}        \tab  \code{numeric vector}   \tab   5\%-quantiles\cr
      \code{median}       \tab  \code{numeric vector}   \tab  50\%-quantiles or \code{NA}\cr 
      \code{upper}        \tab  \code{numeric vector}   \tab  95\%-quantiles 
    }
    The \code{\link{row.names}} are the names of the variables. Each row has the properties of 
    an \code{\link{estimate1d}}. 
    
    Note that the \emph{\code{median}} is a mandatory element of an \code{estimate}, although it
    is not necessary as input. If a component of \code{median} is numeric and not \code{NA} it 
    holds that: \code{lower <= median <= upper}. In any case an \code{estimate} object has the
    property \code{any(lower <= upper)}.     
    }
    \item{\code{$correlation_matrix}}{
     is a symmetric matrix with row and column names being the subset of the variables supplied 
     in \code{$marginal} which are correlated. Its elements are the corresponding correlations.
     }
  }
}
\description{
\code{estimate} creates an object of \code{class estimate}. The concept of an estimate is 
extended from the 1-dimensional (cf. \code{\link{estimate1d}}) to the multivariate case. This 
includes the description of correlations between the different variables. An estimate of an 
n-dimensional variable is at minimum defined by each component being a 1-dimensional estimate. 
This means, that for each component, at minimum, the  type of its univariate parametric 
distribution, its 5\% - and 95\% quantiles must be provided. In probability theoretic terms, 
these are the marginal distributions of the components. Optionally, the individual median 
and the correlations between the components can be supplied.

\code{as.estimate} tries to coerce a set of objects and transform them to \code{class estimate}.
}
\details{
The input arguments inform the estimate about its marginal distributions and joint distribution, i.e.
   the correlation matrix.
  \subsection{The structure of the estimates marginal input information}{
    \describe{
      \item{in \code{estimate}}{
      The marginal distributions are defined by the arguments \code{distribution}, \code{lower}
      and \code{upper} and, optionally, by further columns supplied in \code{...} that can be 
      coerced to a \code{\link{data.frame}} with the same length as the mandatory arguments.
      }
      \item{in \code{as.estimate}}{
        The marginal distributions are completely defined in \code{...}. These arguments must be 
        coercible to a data.frame, all having the same length. Mandatory columns are 
       \code{distribution}, \code{lower} and  \code{upper}. 
      }
    }
    \subsection{Mandatory input columns}{
    \tabular{lll}{
      \bold{Column}       \tab  \bold{R-type}    \tab \bold{Explanation}\cr
      \code{distribution} \tab  \code{character vector} \tab  Marginal distribution types \cr
      \code{lower}        \tab  \code{numeric vector}   \tab  Marginal 5\%-quantiles \cr
      \code{upper}        \tab  \code{numeric vector}   \tab  Marginal 95\%-quantiles 
    }
    It must hold that \code{lower <= upper} for every component of the estimate.  
    }
    \subsection{Optional input columns}{
    The optional parameters in \code{...} provide additional characteristics of the marginal 
    distributions of the estimate. Frequent optional columns are:
    \tabular{lll}{
      \bold{Column}       \tab  \bold{R-type}                 \tab \bold{Explanation}\cr
      \code{variable}     \tab  \code{character vector}       \tab  Variable names\cr
      \code{median}       \tab  cf. below                     \tab  Marginal 50\%-quantiles \cr
      \code{method}       \tab  \code{character vector}       \tab  Methods for calculation of marginal distribution parameters
   }
   \subsection{The \code{median} column}{ 
     If supplied as input, any component of \code{median} can be either \code{NA}, \code{numeric}
     (and not \code{NA}) or the character string \code{"mean"}. If it equals \code{"mean"} it is
     set to \code{rowMeans(cbind(lower, upper))} of this component; if it is \code{numeric} it must
     hold that \code{lower <= median <= upper} for this component. In case that no element 
     \code{median} is provided, the default is \code{median=rep(NA, length(distribution))}.\cr
     The \code{median} is important for the different methods possible in generating the random 
     numbers (cf. \code{\link{random.estimate}}).
   } 
   }
 }
 \subsection{The structure of the estimates correlation input information}{
   The argument \code{correlation_matrix} is the sub matrix of the full correlation matrix of 
   the estimate containing all correlated elements. Thus, its row and column names must be a 
   subset of the variable names of the marginal distributions. This means, that the information  
   which variables are uncorrelated does not need to be provided explicitly.
   
   \code{correlation_matrix} must have all the properties of a correlation matrix, viz. symmetry, 
   all diagonal elements equal 1 and all of diagonal elements are between -1 and 1. 
 }
}
\examples{
# Create a minimum estimate (only mandatory marginal information supplied):
estimateMin<-estimate(c("posnorm", "lnorm"),
                      c(        4,       4),
                      c(       50,      10))
print(estimateMin) 

# Create an estimate with optional columns (only marginal information supplied):
estimateMarg<-estimate(           c("posnorm", "lnorm"),
                                  c(        4,       4),
                                  c(       50,      10),
                         variable=c("revenue", "costs"),
                         median = c(   "mean",      NA),
                         method = c(    "fit",      ""))
print(estimateMarg)
print(corMat(estimateMarg))

# Create a minimum estimate from text (only mandatory marginal information supplied):
estimateTextMin<-"distribution, lower, upper
                  posnorm,      100,   1000
                  posnorm,      50,    2000
                  posnorm,      50,    2000
                  posnorm,      100,   1000"
estimateMin<-as.estimate(read.csv(header=TRUE, text=estimateTextMin, 
                          strip.white=TRUE, stringsAsFactors=FALSE))
print(estimateMin) 

# Create an estimate from text (only marginal information supplied):
estimateText<-"variable,  distribution, lower, upper, median, method
               revenue1,  posnorm,      100,   1000,  NA,        
               revenue2,  posnorm,      50,    2000,    ,     fit
               costs1,    posnorm,      50,    2000,  70,     calculate
               costs2,    posnorm,      100,   1000,  mean,             "
estimateMarg<-as.estimate(read.csv(header=TRUE, text=estimateText, 
                          strip.white=TRUE, stringsAsFactors=FALSE))
print(estimateMarg)
print(corMat(estimateMarg))

# Create an estimate from text (with correlated components): 
estimateTextMarg<-"variable,  distribution, lower, upper
                   revenue1,  posnorm,      100,   1000
                   revenue2,  posnorm,      50,    2000
                   costs1,    posnorm,      50,    2000
                   costs2,    posnorm,      100,   1000"
estimateTextCor<-",         revenue1, costs2
                  revenue1,        1,   -0.3
                  costs2,       -0.3,      1"
estimateCor<-as.estimate(read.csv(header=TRUE, text=estimateTextMarg, 
                          strip.white=TRUE, stringsAsFactors=FALSE),
                          correlation_matrix=data.matrix(read.csv(text=estimateTextCor, 
                                                                  row.names=1,
                                                                  strip.white=TRUE)))
print(estimateCor)
print(corMat(estimateCor))
}
\seealso{
\code{\link{estimate1d}}, \code{\link{random.estimate}}, 
\code{\link{row.names.estimate}}, \code{\link{names.estimate}}, \code{\link{corMat}}, 
\code{\link{estimate_read_csv}} and \code{\link{estimate_write_csv}}.
}
