% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_bitmap-layer.R
\name{add_bitmap_layer}
\alias{add_bitmap_layer}
\title{Add a bitmap layer to the deckgl widget}
\usage{
add_bitmap_layer(deckgl, id = "h3-hexagon-layer", image = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the layer.}

\item{image}{image}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class.}

\item{...}{More properties that will be added to the \code{properties} object. This can be useful
if you want to use a properties object for more than one layer.}
}
\description{
Add a bitmap layer to the deckgl widget
}
\examples{
image <- paste0(
  "https://raw.githubusercontent.com/",
  "uber-common/deck.gl-data/master/",
  "website/sf-districts.png"
)
bounds <- c(-122.5190, 37.7045, -122.355, 37.829)

deck <- deckgl() \%>\%
  add_bitmap_layer(image = image, bounds = bounds) \%>\%
  add_basemap()

if (interactive()) deck
}
