% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/wwz.R
\name{wwz}
\alias{wwz}
\title{Runs the Wang-Wei-Zhu decomposition}
\usage{
wwz(x)
}
\arguments{
\item{x}{an object of the class decompr}
}
\value{
the decomposed table
}
\description{
This function runs the Wang-Wei-Zhu decomposition.
}
\details{
Adapted from code by Fei Wang.
}
\examples{
# load leather example data
data(leather)

# create intermediate object (class decompr)
decompr_object <- load_tables_vectors(inter,
                                      final,
                                      countries,
                                      industries,
                                      out        )

# run the WWZ decomposition on the decompr object
w  <- wwz(decompr_object)
w[1:5,1:5]
}
\author{
Bastiaan Quast
}
\references{
Wang, Zhi, Shang-Jin Wei, and Kunfu Zhu.
Quantifying international production sharing at the bilateral and sector levels.
No. w19677. National Bureau of Economic Research, 2013.
}

