% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_eclairs.R
\name{lm_eclairs}
\alias{lm_eclairs}
\title{Fit linear model after decorrelating}
\usage{
lm_eclairs(
  formula,
  data,
  ecl,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = FALSE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  ...
)
}
\arguments{
\item{formula}{an object of class 'formula' (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{a matrix or data.frame containing the variables in the model}

\item{ecl}{estimate of covariance/correlation matrix from \link{eclairs} storing \eqn{U}, \eqn{d_1^2}, \eqn{\lambda} and \eqn{\nu}}

\item{subset}{same as for \link{lm}}

\item{weights}{same as for \link{lm}}

\item{na.action}{same as for \link{lm}}

\item{method}{same as for \link{lm}}

\item{model}{same as for \link{lm}}

\item{x}{same as for \link{lm}}

\item{y}{same as for \link{lm}}

\item{qr}{same as for \link{lm}}

\item{singular.ok}{same as for \link{lm}}

\item{contrasts}{same as for \link{lm}}

\item{offset}{same as for \link{lm}}

\item{...}{same as for \link{lm}}
}
\value{
Object of class \code{lm} returned by function \link{lm}
}
\description{
Fit linear model after applying decorrelation projection to response and predictors.
}
\details{
This function fit a linear regression to the transformed response, and transformed design matrix.  Note that the design matrix, not just the data.frame of variables is transformed so that 1) factors are transformed and 2) the intercept term is transformed.
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)

# eclairs decomposition
ecl <- eclairs(Y)

# simulate covariates
data <- data.frame(matrnorm(p, 2, seed = 1))
colnames(data) <- paste0("v", 1:2)

# simulate response
y <- rnorm(p)

# fit linear model on transformed data
lm_eclairs(y ~ v1 + v2, data, ecl)

}
