% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linimpute.R
\docType{methods}
\name{impute_lr}
\alias{impute_lr}
\alias{impute_lr,data.frame,validator-method}
\title{Impute values derived from linear (in)equality restrictions.}
\usage{
impute_lr(dat, x, ...)

\S4method{impute_lr}{data.frame,validator}(dat, x, ...)
}
\arguments{
\item{dat}{an R object carrying data}

\item{x}{an R object carrying validation rules}

\item{...}{arguments to be passed to other methods.}
}
\description{
Partially filled records \eqn{\boldsymbol{x}} under linear (in)equality
restrictions may reveal unique imputation solutions when the system
of linear inequalities is reduced by substituting observed values.
This function applies a number of fast heuristic methods before
deriving all variable ranges and unique values.
}
\examples{

v <- validate::validator(y ==2,y + z ==3, x +y <= 0)
dat <- data.frame(x=NA_real_,y=NA_real_,z=NA_real_)
impute_lr(dat,v)

}
