% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grad_test.R
\name{NNgrad_test}
\alias{NNgrad_test}
\title{NNgrad_test function}
\usage{
NNgrad_test(net, loss = Qloss(), eps = 1e-05)
}
\arguments{
\item{net}{an object of class network, see ?network}

\item{loss}{a loss function to compute, see ?Qloss, ?multinomial}

\item{eps}{small value used in the computation of the finite differencing. Default value is 0.00001}
}
\value{
the exact (computed via backpropagation) and approximate (via central finite differencing) gradients and also a plot of one
against the other.
}
\description{
A function to test gradient evaluation of a neural network by comparing it with central finite differencing.
}
\examples{

net <- network( dims = c(5,10,2),
                activ=list(ReLU(),softmax()))
NNgrad_test(net)

}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{backprop_evaluate}, \link{MLP_net}, \link{backpropagation_MLP},
\link{logistic}, \link{ReLU}, \link{smoothReLU}, \link{ident}, \link{softmax}, \link{Qloss}, \link{multinomial},
\link{NNgrad_test}, \link{weights2list}, \link{bias2list}, \link{biasInit}, \link{memInit}, \link{gradInit},
\link{addGrad}, \link{nnetpar}, \link{nbiaspar}, \link{addList}, \link{no_regularisation}, \link{L1_regularisation},
\link{L2_regularisation}
}
