% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_design.R
\name{EI}
\alias{EI}
\alias{EI.gp}
\alias{EI.dgp2}
\alias{EI.dgp3}
\title{Expected Improvement for Sequential Design}
\usage{
EI(object, cores)

\method{EI}{gp}(object, cores = 1)

\method{EI}{dgp2}(object, cores = 1)

\method{EI}{dgp3}(object, cores = 1)
}
\arguments{
\item{object}{object of class \code{gp}, \code{dgp2}, or \code{dgp3} that has been 
predicted over \code{x_new} with \code{lite = TRUE} and \code{store_all = TRUE}}

\item{cores}{number of cores to utilize in parallel, by default no 
parallelization is used}
}
\value{
list with elements:
\itemize{
  \item \code{value}: vector of EI values, indices correspond to \code{x_new}
  \item \code{time}: computation time in seconds
}
}
\description{
Acts on a "\code{gp}", "\code{dgp2}", or "\code{dgp3}" object.  
    Calculates expected improvement over input locations \code{x_new} with 
    the goal of MINIMIZING the function.  Optionally utilizes SNOW 
    parallelization.  User should select the point with the highest EI to 
    add to the design.
}
\details{
The object must be an output of \code{predict} with 
    \code{lite = TRUE} and \code{store_all = TRUE}.  This will store the posterior 
    mean and point-wise variance for every iteration.  Once prediction is done, computation is 
    relatively quick, so SNOW parallelization is only recommended when 
    \code{nmcmc} is large.
}
\examples{
# See "deepgp-package" or "fit_one_layer" for an example

}
\references{
Jones, DR, M Schonlau, and WJ Welch. 1998. "Efficient Global Optimization of 
    Expensive Black-Box Functions." \emph{Journal of Global Optimization 13}, 
    455-492. doi:10.1023/A:1008306431147.
}
