% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getScaleData.R
\name{getScaleData}
\alias{getScaleData}
\title{Get geological timescale data}
\usage{
getScaleData(name)
}
\arguments{
\item{name}{The name of the desired timescale.}
}
\value{
A \code{data.frame} with the following columns:
  \item{name}{the names of the time intervals.}
  \item{max_age}{the oldest boundaries of the time intervals, in millions of years.}
  \item{min_age}{the youngest boundaries of the time intervals, in millions of years.}
  \item{abbr}{either traditional abbreviations of the names of the time intervals (if they exist) or custom abbreviations created with R.}
  \item{color}{hex color codes associated with the time intervals (if applicable).}
}
\description{
This function takes a name of a geological timescale and returns data for the timescale.
Valid names include those of built-in \code{data.frames} (\code{\link{periods}},
\code{\link{epochs}}, \code{\link{stages}}, \code{\link{eons}}, or \code{\link{eras}}),
partial matches of those names (e.g., "per" or "stage"),
and exact matches to those hosted by Macrostrat (see full list here:
\url{https://macrostrat.org/api/defs/timescales?all}).
}
