/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.scoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.WeightedGraph;
import org.jgrapht.alg.interfaces.VertexScoringAlgorithm;

public final class PageRank<V, E>
implements VertexScoringAlgorithm<V, Double> {
    public static final int MAX_ITERATIONS_DEFAULT = 100;
    public static final double TOLERANCE_DEFAULT = 1.0E-4;
    public static final double DAMPING_FACTOR_DEFAULT = 0.85;
    private final Graph<V, E> g;
    private Map<V, Double> scores;

    public PageRank(Graph<V, E> g) {
        this(g, 0.85, 100, 1.0E-4);
    }

    public PageRank(Graph<V, E> g, double dampingFactor) {
        this(g, dampingFactor, 100, 1.0E-4);
    }

    public PageRank(Graph<V, E> g, double dampingFactor, int maxIterations) {
        this(g, dampingFactor, maxIterations, 1.0E-4);
    }

    public PageRank(Graph<V, E> g, double dampingFactor, int maxIterations, double tolerance) {
        this.g = g;
        this.scores = new HashMap<V, Double>();
        if (maxIterations <= 0) {
            throw new IllegalArgumentException("Maximum iterations must be positive");
        }
        if (dampingFactor < 0.0 || dampingFactor > 1.0) {
            throw new IllegalArgumentException("Damping factor not valid");
        }
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance not valid, must be positive");
        }
        this.run(dampingFactor, maxIterations, tolerance);
    }

    @Override
    public Map<V, Double> getScores() {
        return Collections.unmodifiableMap(this.scores);
    }

    @Override
    public Double getVertexScore(V v) {
        if (!this.g.containsVertex(v)) {
            throw new IllegalArgumentException("Cannot return score of unknown vertex");
        }
        return this.scores.get(v);
    }

    private void run(double dampingFactor, int maxIterations, double tolerance) {
        Specifics specifics = this.g instanceof DirectedGraph ? new DirectedSpecifics((DirectedGraph)this.g) : new UndirectedSpecifics(this.g);
        int totalVertices = this.g.vertexSet().size();
        boolean weighted = this.g instanceof WeightedGraph;
        Map<Object, Double> weights = weighted ? new HashMap(totalVertices) : Collections.emptyMap();
        double initScore = 1.0 / (double)totalVertices;
        for (V v : this.g.vertexSet()) {
            this.scores.put((Double)v, initScore);
            if (!weighted) continue;
            double sum = 0.0;
            for (Iterator<Object> e : specifics.outgoingEdgesOf(v)) {
                sum += this.g.getEdgeWeight(e);
            }
            weights.put(v, sum);
        }
        Map<Double, Double> nextScores = new HashMap<V, Double>();
        double maxChange = tolerance;
        while (maxIterations > 0 && maxChange >= tolerance) {
            double r = 0.0;
            for (Object v : this.g.vertexSet()) {
                if (specifics.outgoingEdgesOf(v).size() > 0) {
                    r += (1.0 - dampingFactor) * this.scores.get(v);
                    continue;
                }
                r += this.scores.get(v).doubleValue();
            }
            r /= (double)totalVertices;
            maxChange = 0.0;
            for (Object v : this.g.vertexSet()) {
                double contribution = 0.0;
                if (weighted) {
                    for (Object e : specifics.incomingEdgesOf(v)) {
                        V w = Graphs.getOppositeVertex(this.g, e, v);
                        contribution += dampingFactor * this.scores.get(w) * this.g.getEdgeWeight(e) / (Double)weights.get(w);
                    }
                } else {
                    for (Object e : specifics.incomingEdgesOf(v)) {
                        V w = Graphs.getOppositeVertex(this.g, e, v);
                        contribution += dampingFactor * this.scores.get(w) / (double)specifics.outgoingEdgesOf(w).size();
                    }
                }
                double vOldValue = this.scores.get(v);
                double vNewValue = r + contribution;
                maxChange = Math.max(maxChange, Math.abs(vNewValue - vOldValue));
                nextScores.put((Double)v, vNewValue);
            }
            Map<V, Double> tmp = this.scores;
            this.scores = nextScores;
            nextScores = tmp;
            --maxIterations;
        }
    }

    class UndirectedSpecifics
    extends Specifics {
        private Graph<V, E> graph;

        public UndirectedSpecifics(Graph<V, E> g) {
            this.graph = g;
        }

        public Set<E> outgoingEdgesOf(V vertex) {
            return this.graph.edgesOf(vertex);
        }

        public Set<E> incomingEdgesOf(V vertex) {
            return this.graph.edgesOf(vertex);
        }
    }

    class DirectedSpecifics
    extends Specifics {
        private DirectedGraph<V, E> graph;

        public DirectedSpecifics(DirectedGraph<V, E> g) {
            this.graph = g;
        }

        @Override
        public Set<? extends E> outgoingEdgesOf(V vertex) {
            return this.graph.outgoingEdgesOf(vertex);
        }

        @Override
        public Set<? extends E> incomingEdgesOf(V vertex) {
            return this.graph.incomingEdgesOf(vertex);
        }
    }

    abstract class Specifics {
        Specifics() {
        }

        public abstract Set<? extends E> outgoingEdgesOf(V var1);

        public abstract Set<? extends E> incomingEdgesOf(V var1);
    }
}

