% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cow_iso_clean.R
\name{cow_iso_clean}
\alias{cow_iso_clean}
\title{Clean Up \code{\link[countrycode:countrycode]{countrycode::countrycode()}} CoW > ISO3 conversion.}
\usage{
cow_iso_clean(x, cow.col, iso3.col, year.col)
}
\arguments{
\item{x}{A \code{data.frame} with CoW, ISO3, and year designations.}

\item{cow.col}{A character string of the column name with \strong{numeric} CoW
codes.}

\item{iso3.col}{A character string of the column name with ISO3 \strong{character}
codes.}

\item{year.col}{A character string of the column name for country-\strong{year}
observation.}
}
\value{
A \code{data.frame}.
}
\description{
Given a \code{data.frame} with ISO3 country codes that were derived from a
\code{\link[countrycode:countrycode]{countrycode::countrycode()}} \code{cown > iso3c} formula, clean up the common
errors in coding respective to an additional designation for the year of the
observation.
}
\details{
\code{\link[countrycode:countrycode]{countrycode::countrycode()}} can result in messy ISO3 conversions;
especially when historic data is included. This cleans up some common
post-WWII historical (and other current bugs present at the time of
publishing) ISO3C codes that are useful but no longer part of the current
slate of ISO3C. The
\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{ISO_3166-1_alpha-3}
Wikipedia page was used as reference for this function.
}
\examples{
\donttest{
vdem<-demcon::get_vdem()

vdem$iso3<-countrycode::countrycode(vdem$COWcode, origin = "cown", destination = "iso3c")

vdem<-demcon::cow_iso_clean(x = vdem, cow.col = "COWcode", iso3.col = "iso3", year.col = "year")}
}
