% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_polity5.R
\name{get_polity5}
\alias{get_polity5}
\title{Retrieve the Polity5 Dataset}
\usage{
get_polity5(load = TRUE, del_file = TRUE, excel = TRUE, write_out = FALSE)
}
\arguments{
\item{load}{Logical to load downloaded data into local environment.}

\item{del_file}{Logical to delete downloaded and unzipped files/directories
after loading into the local environment.}

\item{excel}{Logical to download the \code{.xls} (\code{TRUE}) or the SAS \code{.sav} format
(\code{FALSE}).}

\item{write_out}{Logical to write the Polity 5 dataset to your local
directory as a \code{.csv} file.}
}
\value{
A data.frame of Polity5 country-year data.
}
\description{
Download the Polity5 Dataset from the Center for Systemic Peace website.
}
\details{
\subsection{Polity5}{

The Polity5 project continues the Polity research tradition of coding the
authority characteristics of states in the world system for purposes of
comparative, quantitative analysis. The original Polity conceptual scheme was
formulated and the initial Polity I data collected under the direction of Ted
Robert Gurr and informed by foundational, collaborative work with Harry
Eckstein, Patterns of Authority: A Structural Basis for Political Inquiry
(New York: John Wiley & Sons, 1975). The Polity project has proven its value
to researchers over the years, becoming the most widely used resource for
monitoring regime change and studying the effects of regime authority.
\subsection{Structure}{

The Polity5 dataset contains 17,574 country-year observations and 37
variables. For more information regarding variable descriptions and other
dataset documentation, please refer to the
\href{https://www.systemicpeace.org/inscr/p5manualv2018.pdf}{POLITY5: Political Regime Characteristics and Transitions, 1800-2018 Dataset Users’ Manual}.
}

}
}
\examples{
\donttest{
polity <- demcon::get_polity5(excel = TRUE, del_file = TRUE, write_out = FALSE)}

}
