% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriate_dendrogram.R
\name{seriate_dendrogram}
\alias{seriate_dendrogram}
\title{Rotates a dendrogram based on a seriation of a distance matrix}
\usage{
seriate_dendrogram(dend, x, method = c("OLO", "GW"), ...)
}
\arguments{
\item{dend}{An object of class \link{dendrogram} or \link{hclust}}

\item{x}{a \link{dist} object.}

\item{method}{a character vector of either "OLO" or "GW":
"OLO" - Optimal leaf ordering, optimzes the Hamiltonian path length that is restricted by the dendrogram structure - works in O(n^4) 
"GW" - Gruvaeus and Wainer heuristic to optimze the Hamiltonian path length that is restricted by the dendrogram structure}

\item{...}{parameters passed to \link[seriation]{seriate}}
}
\value{
A dendrogram that is rotated based on the optimal ordering of the distance matrix
}
\description{
Rotates a dendrogram so it confirms to an order of a provided distance object.
The seriation algorithm is based on \link[seriation]{seriate}, which tries to find 
a linear order for objects using data in form of a dissimilarity matrix (one mode data).

This is useful for heatmap visualization.
}
\examples{
\dontrun{
# library(dendextend)
d <- dist(USArrests)
hc <- hclust(d, "ave")
dend <- as.dendrogram(hc)

heatmap(as.matrix(USArrests))

dend2 <- seriate_dendrogram(dend, d)
heatmap(as.matrix(USArrests), Rowv = dend)


}
}
\seealso{
\code{\link[dendextend]{rotate}}, \link[seriation]{seriate}
}
