% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clique_community_names_par.R
\name{clique_community_names_par}
\alias{clique_community_names_par}
\title{Clique Percolation Method (with node names)}
\usage{
clique_community_names_par(g, k = 3, n_core = 4)
}
\arguments{
\item{g}{network object (igraph)}

\item{k}{clique size to be used, default set to smallest possible size (3)}

\item{n_core}{number of cores to be used for parrallisation, defaults to 4}
}
\value{
a dataframe with node names and community name. The community is named as CPM_Kk_number_of_community with k replaced by the value of k.
}
\description{
Function to determine communities in a network using clique percolation method (Palla et al., 2005). Communities are created based on cliques. Cliques are subsets of a network that can be considered complete (sub)networks. The size of the cliques to be used to community detection is part of the input of the function.
This function uses parallelisation and should be used for larger networks.
}
\examples{

\dontrun{
hol_sim <- sim_table(hol_rom)
g_hol <- dendro_network(hol_sim, r_threshold = 0.4, sgc_threshold = 0.4)
clique_community_names_par(g_hol, k = 3, n_core = 2)
}

}
\references{
Palla, G., Derényi, I., Farkas, I., & Vicsek, T. (2005). Uncovering the overlapping community structure of complex networks in nature and society. Nature, 435(7043), 814-818.

Code adapted from source: https://github.com/angelosalatino/CliquePercolationMethod-R/blob/master/clique.community.opt.par.R
}
\author{
Angelo Salatino

Ronald Visser
}
