% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_specific.R
\name{plot_specific}
\alias{plot_specific}
\title{plot_specific}
\usage{
plot_specific(result_daily_response, window_width, title = TRUE)
}
\arguments{
\item{result_daily_response}{a list with three objects as produced by
daily_response function}

\item{window_width}{integer representing window width to be displayed}

\item{title}{logical, if set to FALSE, no plot title is displayed}
}
\value{
A ggplot2 object containing the plot display
}
\description{
Graphs a line plot of a row with a selected window width in a matrix,
produced by \code{\link{daily_response}} function.
}
\examples{
\dontrun{
data(daily_temperatures_example)
data(example_proxies_1)
Example1 <- daily_response(response = example_proxies_1,
env_data = daily_temperatures_example, method = "lm", measure = "r.squared",
lower_limit = 90, upper_limit = 150)
plot_specific(Example1, window_width = 90)

Example2 <- daily_response(response = example_proxies_1,
env_data = daily_temperatures_example, method = "lm",
measure = "adj.r.squared", lower_limit = 150, upper_limit = 158,
neurons = 1)
plot_specific(Example2, window_width = 153, title = TRUE)
}
}
