% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_response.R
\name{daily_response}
\alias{daily_response}
\title{daily_response}
\usage{
daily_response(
  response,
  env_data,
  method = "cor",
  metric = "r.squared",
  cor_method = "pearson",
  lower_limit = 30,
  upper_limit = 90,
  fixed_width = 0,
  previous_year = FALSE,
  neurons = 1,
  brnn_smooth = TRUE,
  remove_insignificant = FALSE,
  alpha = 0.05,
  row_names_subset = FALSE,
  aggregate_function = "mean",
  temporal_stability_check = "sequential",
  k = 2,
  k_running_window = 30,
  cross_validation_type = "blocked",
  subset_years = NULL,
  ylimits = NULL,
  seed = NULL,
  tidy_env_data = FALSE,
  reference_window = "start",
  boot = FALSE,
  boot_n = 1000,
  boot_ci_type = "norm",
  boot_conf_int = 0.95,
  day_interval = ifelse(c(previous_year == TRUE, previous_year == TRUE), c(-1, 366),
    c(1, 366)),
  dc_method = NULL,
  cor_na_use = "everything",
  skip_window_length = 1,
  skip_window_position = 1
)
}
\arguments{
\item{response}{a data frame with tree-ring proxy variables as columns and
(optional) years as row names. Row.names should be matched with those from a
env_data data frame. If not, set row_names_subset = TRUE.}

\item{env_data}{a data frame of daily sequences of environmental data as
columns and years as row names. Each row represents a year and
each column represents a day of a year. Row.names should be matched with
those from a response data frame. If not, set row_names_subset = TRUE.
Alternatively, env_data could be a tidy data with three columns,
i.e. Year, DOY and third column representing values of mean temperatures,
sum of precipitation etc. If tidy data is passed to the function, set the argument
tidy_env_data to TRUE.}

\item{method}{a character string specifying which method to use. Current
possibilities are "cor" (default), "lm" and "brnn".}

\item{metric}{a character string specifying which metric to use. Current
possibilities are "r.squared" and "adj.r.squared". If method = "cor",
metric is not relevant.}

\item{cor_method}{a character string indicating which correlation
coefficient is to be computed. One of "pearson" (default), "kendall", or
"spearman".}

\item{lower_limit}{lower limit of window width}

\item{upper_limit}{upper limit of window width}

\item{fixed_width}{fixed width used for calculation. If fixed_width is
assigned a value, upper_limit and lower_limit will be ignored}

\item{previous_year}{if set to TRUE, env_data and response variables will be
rearranged in a way, that also previous year will be used for calculations of
selected statistical metric.}

\item{neurons}{positive integer that indicates the number of neurons used
for brnn method}

\item{brnn_smooth}{if set to TRUE, a smoothing algorithm is applied that
removes unrealistic calculations which are a result of neural net failure.}

\item{remove_insignificant}{if set to TRUE, removes all correlations bellow
the significant threshold level, based on a selected alpha. For "lm" and
"brnn" method, squared correlation is used as a threshold}

\item{alpha}{significance level used to remove insignificant calculations.}

\item{row_names_subset}{if set to TRUE, row.names are used to subset
env_data and response data frames. Only years from both data frames are
kept.}

\item{aggregate_function}{character string specifying how the daily data
should be aggregated. The default is 'mean', the other options are 'median',
'sum', 'min' and 'max'}

\item{temporal_stability_check}{character string, specifying, how temporal stability
between the optimal selection and response variable(s) will be analysed. Current
possibilities are "sequential", "progressive" and "running_window". Sequential check
will split data into k splits and calculate selected metric for each split. Progressive
check will split data into k splits, calculate metric for the first split and then
progressively add 1 split at a time and calculate selected metric. For running window,
select the length of running window with the k_running_window argument.}

\item{k}{integer, number of breaks (splits) for temporal stability and cross validation
analysis.}

\item{k_running_window}{the length of running window for temporal stability check.
Applicable only if temporal_stability argument is set to running window.}

\item{cross_validation_type}{character string, specifying, how to perform cross validation
between the optimal selection and response variables. If the argument is set to "blocked",
years will not be shuffled. If the argument is set to "randomized", years will be shuffled.}

\item{subset_years}{a subset of years to be analyzed. Should be given in the form of
subset_years = c(1980, 2005)}

\item{ylimits}{limit of the y axes for plot_extreme. It should be given in
the form of: ylimits = c(0,1)}

\item{seed}{optional seed argument for reproducible results}

\item{tidy_env_data}{if set to TRUE, env_data should be inserted as a data frame with three
columns: "Year", "DOY", "Precipitation/Temperature/etc."}

\item{reference_window}{character string, the reference_window argument describes,
how each calculation is referred. There are three different options: 'start'
(default), 'end' and 'middle'. If the reference_window argument is set to 'start',
then each calculation is related to the starting day of window. If the
reference_window argument is set to 'middle', each calculation is related to the
middle day of window calculation. If the reference_window argument is set to
'end', then each calculation is related to the ending day of window calculation.
For example, if we consider correlations with window from DOY 15 to DOY 35. If
reference window is set to  'start', then this calculation will be related to the
DOY 15. If the reference window is set to 'end', then this calculation will be
related to the DOY 35. If the reference_window is set to 'middle', then this
calculation is related to DOY 25.
The optimal selection, which describes the optimal consecutive days that returns
the highest calculated metric and is obtained by the $plot_extreme output, is the
same for all three reference windows.}

\item{boot}{logical, if TRUE, bootstrap procedure will be used to calculate
estimates correlation coefficients, R squared or adjusted R squared metrices}

\item{boot_n}{The number of bootstrap replicates}

\item{boot_ci_type}{A character string representing the type of bootstrap intervals
required. The value should be any subset of the values c("norm","basic", "stud",
"perc", "bca").}

\item{boot_conf_int}{A scalar or vector containing the confidence level(s) of
the required interval(s)}

\item{day_interval}{a vector of two values: lower and upper time interval of
days that will be used to calculate statistical metrics. Negative values indicate
previous growing season days. This argument overwrites the calculation
limits defined by lower_limit and upper_limit arguments.}

\item{dc_method}{a character string to determine the method to detrend climate
data.  Possible values are "none" (default) and "SLD" which refers to Simple
Linear Detrending}

\item{cor_na_use}{an optional character string giving a method for computing
covariances in the presence of missing values for correlation coefficients.
This must be (an abbreviation of) one of the strings "everything" (default),
"all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs". See
also the documentation for the base cor() function.}

\item{skip_window_length}{an integer specifying the frequency of window
selection for the calculations of climate-growth relationships. The default
value is 1, indicating that every window is included in the calculations.
When set to a value greater than 1, the function selectively processes
windows at regular intervals defined by this parameter. For instance, if
skip_window_length = 2, the function processes every second window.
Similarly, if skip_window_length = 3, every third window is processed,
skipping two windows in between each selected one. This parameter allows for
controlling the granularity of the analysis and can help in reducing
computation time by focusing on a subset of the data.}

\item{skip_window_position}{an integer specifying the frequency of window
positions used in the calculations of climate-growth relationships. The
default value is 1, indicating that every window position is included in the
calculations. When set to a value greater than 1, the function selectively
processes window positions at regular intervals defined by this parameter.
For instance, if skip_window_position = 2, the function processes every
second window position. Similarly, if skip_window_position = 3, every third
window position is processed, skipping two positions in between each selected
one. This parameter allows for controlling the granularity of the analysis
and can help in reducing computation time by focusing on a subset of the data.}
}
\value{
a list with 17 elements:
\enumerate{
 \item $calculations - a matrix with calculated metrics
 \item $method - the character string of a method
 \item $metric - the character string indicating the metric used for calculations
 \item $analysed_period - the character string specifying the analysed period based on the information from row names. If there are no row names, this argument is given as NA
 \item $optimized_return - data frame with two columns, response variable and aggregated (averaged) daily data that return the optimal results. This data.frame could be directly used to calibrate a model for climate reconstruction
 \item $optimized_return_all - a data frame with aggregated daily data, that returned the optimal result for the entire env_data (and not only subset of analysed years)
 \item $transfer_function - a ggplot object: scatter plot of optimized return and a transfer line of the selected method
 \item $temporal_stability -  a data frame with calculations of selected metric for different temporal subsets
 \item $cross_validation - a data frame with cross validation results
 \item $plot_heatmap - ggplot2 object: a heatmap of calculated metrics
 \item $plot_extreme - ggplot2 object: line plot of a row with the highest value in a matrix of calculated metrics
 \item $type - the character string describing type of analysis: daily or monthly
 \item $reference_window - character string, which reference window was used for calculations
 \item $boot_lower - matrix with lower limit of confidence intervals of bootstrap calculations
 \item $boot_upper - matrix with upper limit of confidence intervals of bootstrap calculations
 \item $aggregated_climate - matrix with all aggregated climate series
}
}
\description{
Function calculates all possible values of a selected statistical metric
between one or more response variables and daily sequences of environmental
data. Calculations are based on moving window which is defined with two
arguments: window width and a location in a matrix of daily sequences of
environmental data. Window width could be fixed (use fixed_width) or
variable width (use lower_limit and upper_limit arguments). In this case,
all window widths between lower and upper limit will be used. All calculated
metrics are stored in a matrix. The location of stored calculated metric
in the matrix is indicating a window width (row names) and a location in a
matrix of daily sequences of environmental data (column names).
}
\examples{
\donttest{

# The examples below are enclosed within donttest{} to minimize the execution
# time during R package checks. Additionally, all examples include the
# parameters `skip_window_length` and `skip_window_position`, which limit the
# number of combinations evaluated in climate-growth correlation calculations.
# To explore all possible combinations, users should set both parameters to 1.

# Load the dendroTools R package
library(dendroTools)

# Load data
data(data_MVA)
data(data_TRW)
data(data_TRW_1)
data(example_proxies_individual)
data(example_proxies_1)
data(LJ_daily_temperatures)

example_basic <- daily_response(response = data_MVA,
                          env_data = LJ_daily_temperatures,
                          row_names_subset = TRUE,
                          fixed_width = 25,
                          lower_limit = 35, upper_limit = 45,
                          remove_insignificant = FALSE,
                          aggregate_function = 'median',
                          alpha = 0.05, cor_method = "spearman",
                          previous_year = FALSE, boot = TRUE,
                          boot_n = 10,
                          skip_window_length = 50,
                          skip_window_position = 50,
                          reference_window = "end", k = 5,
                          dc_method = "SLD",
                          day_interval = c(-100, 250))

# 1 Example with fixed width. Lower and upper limits are ignored.
example_daily_response <- daily_response(response = data_MVA,
    env_data = LJ_daily_temperatures,
    method = "cor", fixed_width = 40, cor_method = "spearman",
    row_names_subset = TRUE, previous_year = TRUE,
    remove_insignificant = TRUE, boot = TRUE,
    alpha = 0.005, aggregate_function = 'mean',
    day_interval = c(-100, 250), skip_window_length = 100,
    reference_window = "start", skip_window_position = 100)

# summary(example_daily_response)
# plot(example_daily_response, type = 1)
# plot(example_daily_response, type = 2)

# 2 Example for past and present. Use subset_years argument.
example_MVA_early <- daily_response(response = data_MVA,
    env_data = LJ_daily_temperatures, cor_method = "kendall",
    method = "lm", lower_limit = 21, upper_limit = 91,
    row_names_subset = TRUE, previous_year = TRUE,
    remove_insignificant = TRUE, alpha = 0.05,
    subset_years = c(1940, 1980),
    fixed_width = 45,
    aggregate_function = 'sum',
    skip_window_length = 50,
    skip_window_position = 50)

example_MVA_late <- daily_response(response = data_MVA,
    env_data = LJ_daily_temperatures,
    method = "cor", lower_limit = 21, upper_limit = 60,
    row_names_subset = TRUE, previous_year = TRUE,
    remove_insignificant = TRUE, alpha = 0.05,
    subset_years = c(1981, 2010),
    skip_window_length = 50,
    skip_window_position = 50)

# plot(example_MVA_early, type = 1)
# plot(example_MVA_late, type = 1)
# plot(example_MVA_early, type = 2)
# plot(example_MVA_late, type = 2)

# 3 Example with negative correlations
example_neg_cor <- daily_response(response = data_TRW_1,
    env_data = LJ_daily_temperatures, previous_year = TRUE,
    method = "cor", lower_limit = 21, upper_limit = 90,
    row_names_subset = TRUE, remove_insignificant = TRUE,
    alpha = 0.05, skip_window_length = 50,
    skip_window_position = 50)

# summary(example_neg_cor)
# plot(example_neg_cor, type = 1)
# plot(example_neg_cor, type = 2)

# 4 Example of multiproxy analysis
# summary(example_proxies_1)
# cor(example_proxies_1)

example_multiproxy <- daily_response(response = example_proxies_1,
   env_data = LJ_daily_temperatures,
   method = "lm", metric = "adj.r.squared",
   lower_limit = 21, upper_limit = 180,
   row_names_subset = TRUE, previous_year = FALSE,
   remove_insignificant = TRUE, alpha = 0.05,
   skip_window_length = 50,
   skip_window_position = 50)

# plot(example_multiproxy, type = 1)

# 5 Example to test the temporal stability
example_MVA_ts <- daily_response(response = data_MVA,
   env_data = LJ_daily_temperatures, method = "brnn",
   lower_limit = 100, metric = "adj.r.squared", upper_limit = 180,
   row_names_subset = TRUE, remove_insignificant = TRUE, alpha = 0.05,
   temporal_stability_check = "running_window", k_running_window = 10,
   skip_window_length = 50, skip_window_position = 50)

# Check the results for temporal stability
# example_MVA_ts$temporal_stability

# 6 Example with nonlinear brnn estimation
example_brnn <- daily_response(response = data_MVA,
   env_data = LJ_daily_temperatures, method = "brnn", boot = FALSE,
   lower_limit = 100, metric = "adj.r.squared", upper_limit = 101,
   row_names_subset = TRUE, remove_insignificant = TRUE, boot_n = 10,
   skip_window_length = 50, skip_window_position = 50)

# summary(example_brnn)
}
}
