% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityClust.R
\name{estimateDc}
\alias{estimateDc}
\title{Estimate the distance cutoff for a specified neighbor rate}
\usage{
estimateDc(distance, neighborRateLow = 0.01, neighborRateHigh = 0.02)
}
\arguments{
\item{distance}{A distance matrix}

\item{neighborRateLow}{The lower bound of the neighbor rate}

\item{neighborRateHigh}{The upper bound of the neighbor rate}
}
\value{
A numeric value giving the estimated distance cutoff value
}
\description{
This function calculates a distance cutoff value for a specific distance 
matrix that makes the average neighbor rate (number of points within the
distance cutoff value) fall between the provided range. The authors of the
algorithm suggests aiming for a neighbor rate between 1 and 2 percent, but 
also states that the algorithm is quite robust with regards to more extreme
cases.
}
\examples{
irisDist <- dist(iris[,1:4])
estimateDc(irisDist)

}
\references{
Rodriguez, A., & Laio, A. (2014). Clustering by fast search and find of density peaks. Science, 344(6191), 1492-1496. doi:10.1126/science.1242072
}

