% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{serofit}
\alias{serofit}
\title{Model fitting for serological data}
\usage{
serofit(seropositive, N, age.min = use.default(1L:length(seropositive),
  "age.min"), age.max = use.default(age.min, "age.max"))
}
\arguments{
\item{seropositive, }{the number of seropositive samples for each age group; length(seropositive) must be at least 3}

\item{N, }{the total number of samples for each age group; length(N) must equal length(seropositive)}

\item{age.min, }{the low age in age groups; defaults to `1:length(seropositive)`, i.e. assumes
the seropositive data corresponds to yearly cohorts starting at age 1.}

\item{age.max, }{the upper age in age groups; defaults to `age.min`, i.e. assumes each category corresponds
to a single year}
}
\value{
a list of best-fit parameters, all numeric values:
\describe{
  \item{f_H}{force of infection, for the high risk group}
  \item{f_L}{force of infection, for the low risk group}
  \item{p_H}{the proportion of the population at high risk}
}
}
\description{
Model fitting for serological data
}
\details{
Fits a constant force of infection, two-risk category model using
  seroprevalence survey data. i.e.:

  $$
  P_+(A) = p_H * (1-(1-f_H)^A) + (1-p_H) * (1-(1-f_L)^A)
  $$

  This probability is fit to the seroprevalence by age category data,
  using maximum likelihood and \code{\link[stats]{optim}}.
}
\examples{
require(denvax);
data(morrison2010) # has counts by age
fit <- with(morrison2010, serofit(sero=Seropositive, N=Number, age.min=Age))
if (requireNamespace("data.table", quietly = TRUE)) {
data(lazou2016) # has counts by age range, instead of counts for every year
# this example uses `data.table`` functions to simplify processing
# several groups at once
  lazou2016[,{
    agerange <- data.table::tstrsplit(Age, "-")
    serofit(
      sero     = Seropositive,
      N        = Number,
      age.min  = as.integer(agerange[[1]]),
      age.max  = as.integer(agerange[[2]])
    )
  }, by = Country]
}
}
