% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{lf.delta.beta1}
\alias{lf.delta.beta1}
\title{Loss function to compute Delta(beta).}
\usage{
lf.delta.beta1(
  Delta.sub,
  vnb,
  phi,
  Gn,
  Omegan,
  beta,
  c,
  r,
  data,
  par.space,
  epsilon.n,
  lambda.n
)
}
\arguments{
\item{Delta.sub}{Subvector of Delta.}

\item{vnb}{Bootstrapped stochastic process.}

\item{phi}{Moment selection functions.}

\item{Gn}{First-order approximation matrix.}

\item{Omegan}{Correlation matrix of sample moment functions.}

\item{beta}{Coefficient vector.}

\item{c}{Projection vector.}

\item{r}{Value of projected coefficient vector.}

\item{data}{Data frame.}

\item{par.space}{Matrix containing the bounds on the parameter space.}

\item{epsilon.n}{Parameter used in constructing the feasible region as in
Example 4.1 in Bei (2024). Not used in this function.}

\item{lambda.n}{Weight of penalty term.}
}
\value{
Loss function evaluation evaluated at the given Delta.
}
\description{
This function defines the loss function used in computing the
penalized local linear approximation of the test statistic in order to
construct the bootstrap distribution of the test statistic.
}
\references{
Bei, X. (2024). Local linearieation based subvector inference in
moment inequality models. Journal of Econometrics. 238:105549-
}
