% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_len.R
\name{pb_len}
\alias{pb_len}
\alias{tick}
\title{Progress bar of given length}
\usage{
pb_len(.x, width = 76L, show_after = 2L, clear = FALSE)

tick(pb, what = "")
}
\arguments{
\item{.x}{(int) total number of step to count}

\item{width}{(int, default = 76) total console width used by the bar}

\item{show_after}{(num, default = 2) minimum number of seconds needed
for the process to display the progress bar}

\item{clear}{(lgl, default = FALSE) if TRUE, at the end of the
process the progress bar will be cleared}

\item{pb}{an object of class \code{\link[progress]{progress_bar}}}

\item{what}{(chr, default = "") short prompt to see at the beginning
of the progressbar}
}
\value{
a \code{\link[progress]{progress_bar}} object
}
\description{
Simple wrapper for \code{\link[progress]{progress_bar}} for standard
and quickly ready progress bars; including messages, bar progression,
percentage and time elapsed, and ETA.
}
\section{Functions}{
\itemize{
\item \code{tick}: wrapper function to update the progress bar
}}

\examples{
\donttest{
  pb <- pb_len(100)
  for (i in 1:100) {
    Sys.sleep(0.1)
    tick(pb, paste("i = ", i))
  }
}
}
