% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt_nb.r
\name{lrt_nb}
\alias{lrt_nb}
\title{Likelihood ratio test for NB ratio of means}
\usage{
lrt_nb(data, equal_dispersion = FALSE, ratio_null = 1, ...)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of negative binomial values
from group 1 and the second element is the vector of negative binomial
values from group 2.
\link[base]{NA}s are silently excluded. The default output from
\code{\link[=sim_nb]{sim_nb()}}.}

\item{equal_dispersion}{(Scalar logical: \code{FALSE})\cr
If \code{TRUE}, the LRT is calculated assuming both groups have the same
population dispersion parameter. If \code{FALSE} (default), the LRT is
calculated assuming different dispersions.}

\item{ratio_null}{(Scalar numeric: \code{1}; \verb{(0, Inf)})\cr
The ratio of means assumed under the null hypothesis (group 2 / group 1).
Typically \code{ratio_null = 1} (no difference). See 'Details' for
additional information.}

\item{...}{Optional arguments passed to the MLE function \code{\link[=mle_nb]{mle_nb()}}.}
}
\value{
A list with the following elements:
\tabular{llll}{
Slot \tab Subslot \tab Name \tab Description \cr
1 \tab  \tab \code{chisq} \tab Asymptotic \eqn{\chi^2} test statistic for the ratio of means. \cr
2 \tab  \tab \code{df}    \tab Degrees of freedom. \cr
3 \tab  \tab \code{p}     \tab p-value. \cr
4 \tab  \tab \code{ratio} \tab Estimated ratio of means (group 2 / group 1). \cr

5 \tab   \tab \code{alternative} \tab Point estimates under the alternative hypothesis. \cr
5 \tab 1 \tab \code{mean1}       \tab Estimated mean of group 1. \cr
5 \tab 2 \tab \code{mean2}       \tab Estimated mean of group 2. \cr
5 \tab 3 \tab \code{dispersion1} \tab Estimated dispersion of group 1. \cr
5 \tab 4 \tab \code{dispersion2} \tab Estimated dispersion of group 2. \cr

6 \tab   \tab \code{null} \tab Point estimates under the null hypothesis. \cr
6 \tab 1 \tab \code{mean1}       \tab Estimated mean of group 1. \cr
6 \tab 2 \tab \code{mean2}       \tab Estimated mean of group 2. \cr
6 \tab 3 \tab \code{dispersion1} \tab Estimated dispersion of group 1. \cr
6 \tab 4 \tab \code{dispersion2} \tab Estimated dispersion of group 2. \cr

7 \tab \tab \code{n1} \tab Sample size of group 1. \cr
8 \tab \tab \code{n2} \tab Sample size of group 2. \cr
9 \tab \tab \code{method} \tab Method used for the results. \cr
10 \tab \tab \code{equal_dispersion} \tab Whether or not equal dispersions were assumed. \cr
11 \tab \tab \code{ratio_null} \tab Assumed population ratio of means. \cr
12 \tab \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
13 \tab \tab \code{mle_message} \tab Information from the optimizer.
}
}
\description{
Likelihood ratio test for the ratio of means from two independent negative
binomial outcomes.
}
\details{
This function is primarily designed for speed in simulation. Missing values
are silently excluded.

Suppose \eqn{X_1 \sim NB(\mu, \theta_1)} and
\eqn{X_2 \sim NB(r\mu, \theta_2)} where \eqn{X_1} and \eqn{X_2} are
independent, \eqn{X_1} is the count outcome for items in group 1, \eqn{X_2}
is the count outcome for items in group 2, \eqn{\mu} is the arithmetic mean
count in group 1, \eqn{r} is the ratio of arithmetic means for group 2 with
respect to group 1, \eqn{\theta_1} is the dispersion parameter of group 1,
and \eqn{\theta_2} is the dispersion parameter of group 2.

The hypotheses for the LRT of \eqn{r} are

\deqn{
\begin{aligned}
H_{null} &: r = r_{null} \\
H_{alt} &: r \neq r_{null}
\end{aligned}
}

where \eqn{r = \frac{\bar{X}_2}{\bar{X}_1}} is the population ratio of
arithmetic means for group 2 with respect to group 1 and \eqn{r_{null}} is a
constant for the assumed null population ratio of means (typically
\eqn{r_{null} = 1}).

The LRT statistic is

\deqn{
\begin{aligned}
\lambda &= -2 \ln \frac{\text{sup}_{\Theta_{null}} L(r, \mu, \theta_1, \theta_2)}{\text{sup}_{\Theta} L(r, \mu, \theta_1, \theta_2)} \\
  &= -2 \left[ \ln \text{sup}_{\Theta_{null}} L(r, \mu, \theta_1, \theta_2) - \ln \text{sup}_{\Theta} L(r, \mu, \theta_1, \theta_2) \right] \\
  &= -2(l(r_{null}, \tilde{\mu}, \tilde{\theta}_1, \tilde{\theta}_2) - l(\hat{r}, \hat{\mu}, \hat{\theta}_1, \hat{\theta}_2))
\end{aligned}
}

Under \eqn{H_{null}}, the LRT test statistic is asymptotically distributed
as \eqn{\chi^2_1}. The approximate level \eqn{\alpha} test rejects
\eqn{H_{null}} if \eqn{\lambda \geq \chi^2_1(1 - \alpha)}. Note that
the asymptotic critical value is known to underestimate the exact critical
value. Hence, the nominal significance level may not be achieved for small
sample sizes (possibly \eqn{n \leq 10} or \eqn{n \leq 50}).
}
\examples{
#----------------------------------------------------------------------------
# lrt_nb() examples
#----------------------------------------------------------------------------
library(depower)

set.seed(1234)
sim_nb(
  n1 = 60,
  n2 = 40,
  mean1 = 10,
  ratio = 1.5,
  dispersion1 = 2,
  dispersion2 = 8
) |>
  lrt_nb()

}
\references{
\insertRef{rettiganti_2012}{depower}

\insertRef{aban_2009}{depower}
}
