% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description.R
\name{desc}
\alias{desc}
\title{Read a DESCRIPTION file}
\usage{
desc(cmd = NULL, file = NULL, text = NULL, package = NULL)
}
\arguments{
\item{cmd}{A command to create a description from scratch.
Currently only \code{"!new"} is implemented. If it does not start
with an exclamation mark, it will be interpreted as the \sQuote{file}
argument.}

\item{file}{Name of the \code{DESCRIPTION} file to load. If all of
\sQuote{cmd}, \sQuote{file} and \sQuote{text} are \code{NULL} (the
default), then the \code{DESCRIPTION} file in the current working
directory is used. The file can also be an R package (source, or
binary), in which case the DESCRIPTION file is extracted from it, but
note that in this case \code{$write()} cannot write the file back in
the package archive.}

\item{text}{A character scalar containing the full DESCRIPTION.
Character vectors are collapsed into a character scalar, with
newline as the separator.}

\item{package}{If not NULL, then the name of an installed package
and the DESCRIPTION file of this package will be loaded.}
}
\description{
This is a convenience wrapper for \code{description$new()}.
Very often you want to read an existing \code{DESCRIPTION}
file, and to do this you can just supply the path to the file or its
directory to \code{desc()}.
}
\examples{
desc(package = "desc")
DESCRIPTION <- system.file("DESCRIPTION", package = "desc")
desc(DESCRIPTION)
}
