% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-freq-cont.R
\name{ds_freq_cont}
\alias{ds_freq_cont}
\alias{freq_cont}
\alias{plot.ds_freq_cont}
\title{Frequency distribution of continuous data}
\usage{
ds_freq_cont(data, variable, bins = 5)

\method{plot}{ds_freq_cont}(x, ...)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{tibble}.}

\item{variable}{Column in \code{data}.}

\item{bins}{Number of intervals into which the data must be split.}

\item{x}{An object of class \code{ds_freq_cont}.}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
A tibble.
}
\description{
Frequency distribution of continuous data by splitting into equidistant
intervals created based on the number of bins specified.
\code{hist.ds_freq_cont()} creates histogram for the frequency table
created using \code{ds_freq_cont()}.
}
\section{Deprecated functions}{

\code{freq_cont()} has been deprecated. Instead use \code{ds_freq_cont()}.
}

\examples{
# frequency table
ds_freq_cont(mtcarz, mpg, 4)

# histogram
k <- ds_freq_cont(mtcarz, mpg, 4)
plot(k)

}
\seealso{
\code{\link{ds_freq_table}} \code{\link{ds_cross_table}}
}
