% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate.R
\docType{package}
\name{devRate}
\alias{devRate}
\alias{devRate-package}
\title{devRate: A package to quantify the relationship between development rate and temperature in ectotherms.}
\description{
The devRate package allows quantifying the relationship between development rate and temperature in ectotherm organisms.
}
\section{Citation}{


Please use \code{citation("devRate")} to cite the devRate package.

Author's affiliation: UMR EGCE, Univ. ParisSud, CNRS, IRD, Univ. ParisSaclay, Gif-sur-Yvette, France
}

\section{Overview}{


The devRate package provides three categories of functions:

- to find development rate information about a specific organism (Order, Family, Genus, species): which equations were used and what are the associated parameters (e.g., helpful to estimate starting values for your empirical data sets);

- to relate development rate and temperature; and

- to plot your empirical datasets and the associated fitted model, and/or to plot development curves from the literature.
}

\section{Usage}{


You can use the package:

- to get development rate curves as a function of temperature for a specific organism (hundred of examples from the literature are included in the package);

- to know which equations exists and which are most used in the literature; and

- to relate development rate with temperature from your empirical data, using the equations from the package database.
}

\section{Installation instructions}{


\code{install.packages("devRate")}
}

\section{Documentation}{


The package includes two vignettes (long-form documentation):

- quickUserGuide: Using devRate package to fit development rate models to an empirical dataset

- modelEvaluation: Model evaluation using Shi et al. 2016 study
}

