% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{perf2_11}
\alias{perf2_11}
\title{Performance-2 equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}}
\source{
\url{http://dx.doi.org/10.1016/j.aspen.2010.11.008}
}
\usage{
perf2_11
}
\description{
Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.

Wang, L., P. Shi, C. Chen, and F. Xue. 2013. Effect of temperature on the development
of Laodelphax striatellus (Homoptera: Delphacidae). J. Econ. Entomol. 106: 107-114.

Shi, P. J., Reddy, G. V., Chen, L., and Ge, F. (2016). Comparison of Thermal
Performance Equations in Describing Temperature-Dependent Developmental Rates
of Insects:(I) Empirical Models. Annals of the Entomological Society of America, 109(2), 211-215.
}
\details{
Equation:
\deqn{rT = cc * (T - T1) * (1 - e^{k * (T - T2)})}{%
      rT = cc * (T - T1) * (1 - exp(k * (T - T2)))}

where rT is the development rate, T the temperature, T1 and T2 the conceptual
lower and upper developmental thresholds at which development rates equal zero,
and cc and k constants.
}
\keyword{datasets}
