% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\alias{test_coverage}
\alias{uses_testthat}
\alias{test_file}
\alias{test_coverage_file}
\title{Execute \pkg{test_that} tests in a package.}
\usage{
test(pkg = ".", filter = NULL, ...)

test_coverage(pkg = ".", show_report = interactive(), ...)

uses_testthat(pkg = ".")

test_file(file = find_active_file(), ...)

test_coverage_file(file = find_active_file(), filter = TRUE,
  show_report = interactive(), ...)
}
\arguments{
\item{pkg}{package description, can be path or package name. See
\code{\link[=as.package]{as.package()}} for more information}

\item{filter}{If not \code{NULL}, only tests with file names matching this
regular expression will be executed.  Matching will take on the file
name after it has been stripped of \code{"test-"} and \code{".R"}.}

\item{...}{additional arguments passed to \code{\link[testthat:test_dir]{testthat::test_dir()}} and
\code{\link[covr:package_coverage]{covr::package_coverage()}}}

\item{show_report}{Show the test coverage report.}

\item{file}{One or more source or test files. If a source file the
corresponding test file will be run. The default is to use the active file
in RStudio (if available).}
}
\description{
\code{test()} is a shortcut for \code{\link[testthat:test_dir]{testthat::test_dir()}}, it runs all of a
package's tests.
\code{test_file} runs \code{test()} on the active file.
\code{test_coverage()} computes test coverage for your package. It is a shortcut
for \code{\link[covr:package_coverage]{covr::package_coverage()}} and \code{\link[covr:report]{covr::report()}}.
\code{test_coverage_file()} computes test coverage for the active file. Is a
shortcut for \code{\link[covr:file_coverage]{covr::file_coverage()}} and \code{\link[covr:report]{covr::report()}}.
}
