% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{fit_domains}
\alias{fit_domains}
\title{Estimate the Rasch and the Interaction model per domain}
\usage{
fit_domains(db, booklets, domains)
}
\arguments{
\item{db}{A handle to the database, i.e. the output of \code{start_new_project}
or \code{open_project}}

\item{booklets}{A vector with the numbers of the test forms (booklets)
to be included in the analysis. See Details.}

\item{domains}{The variable name for the item property defining the 
domains (subtests)}
}
\value{
An object of class \code{imp} holding results
for the Rasch model and the interaction model.
}
\description{
Estimate the parameters of the Rasch model and the Interaction model
}
\details{
Unlike the Rasch model, the interaction model cannot be computed
concurrently for a whole design of test forms. This function fits the
Rasch model and the interaction model on a complete rectagular array of
responses, with comparison between the two models playing an important role.
The rectangular array may be either one booklet or the intersection (common items)
of two or more booklets. If the intersection is empty (no common items), the
function will exit with an error message.

Please notice that the booklets are specified with their internal numbers
in the data base, not with their names. The names and numbers of the booklets
can be inspected with functopn \code{show_booklets}.
}
\author{
Gunter Maris, Timo Bechger, Ivailo Partchev
}

