% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{start_new_project}
\alias{start_new_project}
\title{Start a new project}
\usage{
start_new_project(rules, db_name = "dexter.db")
}
\arguments{
\item{rules}{A data frame with columns \code{item}, \code{response}, and \code{score}.
The order is not important but spelling is. Any other columns will be ignored.}

\item{db_name}{A name for the data base that will be created. If the name does not
contain a path, the file will be created in the work
directory. Any existing file with the same name will be overwritten.}
}
\value{
If the scoring rules pass a sanity check, a handle to the data base.
Otherwise, a data frame listing the problems found.
}
\description{
Imports a complete set of scoring rules and starts a new project (data base)
}
\details{
This package only works with closed items: it does not score any open items.
The first step to creating a project is to import an exhaustive list of all items and
all admissible responses, along with the score that any of the latter will be given.
Responses may be numbers or strings, and they must appear exactly as in the data
that will be imported. Scores must be integers, and the minimum score for an item
must be 0. When inputting data, all responses not on the list will be treated as
missing and ultimately scored 0, but it is good style to include the missing
responses in the list.
importFrom RSQLite dbConnect dbReadTable dbWriteTable dbListFields
importFrom RSQLite dbGetQuery dbSendQuery
}
\author{
Ivailo Partchev
}

