\name{pkcov}
\alias{pkcov}
\title{
Dose finding method PKCOV.
}

\description{
The PKCOV model is a modification of the method proposed by Piantadosi and Liu (1996) who suggested to use the AUC as covariate for \eqn{p_T}, probability of toxicity, through the logit link. Therefore, the dose-toxicity model is:

\deqn{logit(p_T(d_k, \Delta {z_d}_k, \boldsymbol{\beta})) = -\beta_0 + \beta_1 log(d_k) + \beta_2 \Delta {z_d}_k}

where \eqn{\boldsymbol{\beta} = (\beta_1, \beta_2)}, \eqn{\beta_0} is a constant
with \eqn{\beta_0 = -beta0mean},
\deqn{\beta_1 \sim U(l_1, u_1),}
\deqn{\beta_2 \sim U(0,5),}
\deqn{beta1mean = c(l_1, u_1)}
where default choices are beta0mean = -14.76, beta1mean = c(0, 8.23) and \eqn{\Delta {z_d}_k} is the difference between the logarithm of population AUC at dose \eqn{d_k} and z, the logarithm of AUC of the subject at the same dose. Therefore, the default choices for model's priors are given by \deqn{betapriors = c(beta0mean = -14.76, l_1 = 0, u_1 = 8.23)}

Finally, the PKCOV model has the following stopping rule in toxicity:
if
\deqn{P(p_T(dose) > theta) > prob}
then, no dose is suggested and the trial is stopped. 
}

\usage{
pkcov(y,auc,doses,x,theta, deltaAUC, prob = 0.9, options=list(nchains = 4,
      niter = 4000, nadapt = 0.8), betapriors = c(-14.76, 0, 3.23+5), 
      thetaL = NULL, p0 = NULL, L = NULL, CI =TRUE)
}

\arguments{
\item{y}{
    A binary vector of patient's toxicity outcomes; TRUE indicates a toxicity, FALSE otherwise.
}
\item{doses}{
    A vector with the doses panel.
}
\item{x}{
    A vector with the dose level assigned to the patients.
}
\item{theta}{
    The toxicity target.
}
\item{prob}{
    The threshold of the posterior probability of toxicity for the stopping rule; defaults to 0.9.
}
\item{betapriors}{
    A vector with the value for the prior distribution of the regression parameters in the model; defaults to betapriors = c(beta0mean, beta1mean), where beta0mean = -14.76 and beta1mean = c(0, 8.23).
}
\item{options}{
    A list with the Stan model's options; the number of chains, how many iterations for each chain and the number of warmup iterations; defaults to options = list(nchains = 4, niter = 4000, nadapt = 0.8).
}
\item{auc}{
    A vector with the computed AUC values of each patient for pktox, pkcrm, pklogit and pkpop; defaults to NULL.
}
\item{deltaAUC}{
    The difference between computed individual AUC and the AUC of the population at the same dose level (defined as an average); argument for pkcov; defaults to NULL.
}
\item{p0}{
    The skeleton of CRM for pkcrm; defaults to NULL (must be defined only in the PKCRM model).
}
\item{L}{
    The AUC threshold to be set before starting the trial for pklogit, pkcrm and pktox; defaults to NULL (must be defined only in the PKCRM model).
}
\item{thetaL}{
    A second threshold of AUC; must be defined only in the PKCRM model. 
}
\item{CI}{
    A logical constant indicating the estimated 95\% credible interval; defaults to TRUE.
}
}

\value{
A list is returned, consisting of determination of the next recommended dose and estimations of the model. Objects generated by pkcov contain at least the following components:

\item{newDose}{The next maximum tolerated dose (MTD); equals to "NA" if the trial has stopped before the end, according to the stopping rules.}
\item{pstim}{The mean values of estimated probabilities of toxicity.}
\item{p_sum}{The summary of the estimated probabilities of toxicity if CI = TRUE, otherwise is NULL.}
\item{parameters}{The estimated model's parameters.}
}

\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal.

Piantadosi, S. and Liu, G. (1996) Improved designs for dose escalation studies using pharmacokinetic measurements. Statistics in Medicine, 15 (15), 1605-1618.
}

\author{Artemis Toumazi \email{artemis.toumazi@inserm.fr},
        Moreno Ursino \email{moreno.ursino@inserm.fr},
        Sarah Zohar \email{sarah.zohar@inserm.fr}
        }

\seealso{
\code{\link{sim.data}}, \code{\link{nsim}}, \code{\link{nextDose}}
}

\examples{
\dontrun{
doses <- c(12.59972,34.65492,44.69007,60.80685,83.68946,100.37111)
theta <- 0.2
AUCs <-  c(0.43, 1.4, 5.98, 7.98, 11.90, 3.45)
x <- c(1,2,3,4,5,6)
y <- c(FALSE,FALSE,FALSE,FALSE,TRUE,FALSE)
deltaAUC <- c(0, 1.3, -0.34, -2.7, 0.39, -2.45)
options <- list(nchains = 2, niter = 4000, nadapt = 0.8)
res <- pkcov(y, AUCs, doses, x, theta, deltaAUC, options=options)
}
}

\keyword{models}
