% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_decom.R
\name{value_decom}
\alias{value_decom}
\title{Decomposing Value Added Growth into Explanatory Factors}
\usage{
value_decom(x, w, y, p, t, data)
}
\arguments{
\item{x}{A string (or a vector of strings) indicating the quantity columns.}

\item{w}{A string (or a vector of strings) indicating the input price columns.}

\item{y}{A string (or a vector of strings) indicating the the output quantity columns.}

\item{p}{A string (or a vector of strings) indicating the the output price columns.}

\item{t}{A string indicating the time period column.}

\item{data}{A data frame containing input prices, input quantities, output prices,
output quantities, and the time period.}
}
\value{
A list containing a growth-value table and a level-value table of explanatory factors
for value added growth decomposition. It is sorted by the time period.
}
\description{
This method for decomposing nominal value added growth is
proposed by Diewert and Fox (2018), which identifies the
contributions from efficiency change, growth of primary
inputs, changes in output and input prices, technical
progress and returns to scale.
}
\examples{
# Use the built-in dataset "mining"
table1 <- value_decom(c("h2","x2"), c("w2","u2"), "y2", "p2", "year", mining)[[1]]
table2 <- value_decom(c("h2","x2"), c("w2","u2"), "y2", "p2", "year", mining)[[2]]
}
\references{
Diewert, W. E. and Fox, K. J. (2018). Decomposing value added growth into explanatory
factors. In The Oxford Handbook of Productivity Analysis, chapter 19,
page 625--662. Oxford University Press: New York.
}
