% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nllik}
\alias{nllik}
\title{Calculate negative predicted log-likelihood}
\usage{
nllik(object, x, y)
}
\arguments{
\item{object}{an instance of the \code{dgp} class and it should be produced by \code{\link[=dgp]{dgp()}} with one of the following two settings:
\enumerate{
\item if \code{struc = NULL}, \code{likelihood} is not \code{NULL};
\item if a customized structure is provided to \code{struc}, the final layer must be likelihood layer containing only one
likelihood node produced by \code{\link[=Poisson]{Poisson()}}, \code{\link[=Hetero]{Hetero()}}, or \code{\link[=NegBin]{NegBin()}}.
}}

\item{x}{a matrix where each row is an input testing data point and each column is an input dimension.}

\item{y}{a matrix with only one column where each row is a scalar-valued testing output data point.}
}
\value{
An updated \code{object} is returned with an additional slot named \code{NLL} that contains two elements.
The first one, named \code{meanNLL}, is a scalar that gives the average negative predicted log-likelihood
across all testing data points. The second one, named \code{allNLL}, is a vector that gives the negative predicted
log-likelihood for each testing data point.
}
\description{
This function computes the negative predicted log-likelihood from a
DGP emulator with a likelihood layer.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
Any R vector detected in \code{x} and \code{y} will be treated as a column vector and automatically converted into a single-column
R matrix. Thus, if \code{x} is a single testing data point with multiple dimensions, it must be given as a matrix.
}
\examples{
\dontrun{

# Check https://mingdeyu.github.io/dgpsi-R/ for examples
# on how to compute the negative predicted log-likelihood
# using nllik().
}
}
