% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_map.R
\name{cluster_map}
\alias{cluster_map}
\title{Visualize dialect groups with clustering methods}
\usage{
cluster_map(dist_mat, kml_points, kml_polygon, cluster_num, method)
}
\arguments{
\item{dist_mat}{A distance matrix.}

\item{kml_points}{A dataframe of kml (Keyhole Markup Language) points, as retrieved by \code{\link{get_points}}.}

\item{kml_polygon}{A dataframe of kml polygons, as retrieved by \code{\link{get_polygons}}.}

\item{cluster_num}{Number of clusters.}

\item{method}{The agglomeration method that is passed to \code{\link[stats]{hclust}}. This can be chosen from the following: "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}
}
\value{
A map upon which dialect areas are clustered.
}
\description{
Input a distance matrix, upon which clustering will be performed and projected unto a map.
}
\examples{
# Example 1: A cluster map of Dutch dialects
data(distDutch)
dutch_points <- get_points(system.file("extdata", "DutchKML.kml", package="dialectR"))
dutch_polygons <- get_polygons(system.file("extdata", "DutchKML.kml", package="dialectR"))
cluster_map(distDutch[1:100,1:100], dutch_points, dutch_polygons, 5, "ward.D2")
}
