% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-phone_old.R
\name{phone_old}
\alias{ph_valid}
\alias{ph_region}
\alias{ph_possible}
\alias{ph_format}
\alias{ph_type}
\alias{ph_example}
\title{Old one shot phone functions}
\usage{
ph_valid(phone, country, strict = FALSE)

ph_region(phone, country)

ph_possible(phone, country, detailed = FALSE)

ph_format(phone, country, format = "NATIONAL", home = NULL, clean = FALSE)

ph_type(phone, country)

ph_example(country, type = NULL, home = NULL, clean = FALSE)
}
\description{
This set of methods is a relic of the early development of dialr. They are
significantly slower than the current approach. They were soft deprecated in
0.2.0, hard deprecated in 0.4.0 and will be entirely removed in the next
major release.

All functions have a corresponding function in the current version of dialr.
Due to the changes in approach, the new versions of each function are not
drop-in replacements and most need a parsed phone vector as input. See the
introductory vignette or the \link{phone} class documentation for more detail.
\itemize{
\item \code{ph_valid()} -> \code{\link[=is_valid]{is_valid()}}
\item \code{ph_region()} -> \code{\link[=get_region]{get_region()}}
\item \code{ph_possible()} -> \code{\link[=is_possible]{is_possible()}}
\item \code{ph_format()} -> \code{\link[=format.phone]{format.phone()}}
\item \code{ph_type()} -> \code{\link[=get_type]{get_type()}}
\item \code{ph_example()} -> \code{\link[=get_example]{get_example()}}
}
}
\keyword{internal}
