% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{graphs}
\alias{graphs}
\alias{graph_cdf}
\alias{graph_delta_area}
\alias{graph_heatmap}
\alias{graph_tracking}
\alias{graph_all}
\title{Graphical Displays}
\usage{
graph_cdf(mat)

graph_delta_area(mat)

graph_heatmap(mat, main = NULL, ...)

graph_tracking(cl)

graph_all(x, ...)
}
\arguments{
\item{mat}{same as \code{x}, or a list of consensus matrices computed from \code{x} for
faster results}

\item{main}{heatmap title. If \code{NULL} (default), the titles will be taken from
names in \code{mat}}

\item{...}{additional arguments to \code{\link[gplots:heatmap.2]{gplots::heatmap.2()}}}

\item{cl}{same as \code{x}, or a matrix of consensus classes computed from \code{x} for
faster results}

\item{x}{an object from \code{\link[=consensus_cluster]{consensus_cluster()}}}
}
\value{
Various plots from \code{graph_*{}} functions. All plots are
generated using \code{ggplot}, except for \code{graph_heatmap}, which uses
\code{\link[gplots:heatmap.2]{gplots::heatmap.2()}}. Colours used in \code{graph_heatmap} and \code{graph_tracking}
utilize \code{\link[RColorBrewer:RColorBrewer]{RColorBrewer::RColorBrewer()}} palettes.
}
\description{
Graph cumulative distribution function (CDF) graphs, relative change in area
under CDF curves, heatmaps, and cluster assignment tracking plots.
}
\details{
\code{graph_cdf} plots the CDF for consensus matrices from different algorithms.
\code{graph_delta_area} calculates the relative change in area under CDF curve
between algorithms. \code{graph_heatmap} generates consensus matrix heatmaps for
each algorithm in \code{x}. \code{graph_tracking} tracks how cluster assignments change
between algorithms. \code{graph_all} is a wrapper that runs all graphing
functions.
}
\examples{
# Consensus clustering for 3 algorithms
library(ggplot2)
set.seed(911)
x <- matrix(rnorm(100), ncol = 10)
CC1 <- consensus_cluster(x, nk = 2:4, reps = 3,
algorithms = c("hc", "pam", "km"), progress = FALSE)

# Plot CDF
p <- graph_cdf(CC1)

# Change y label and add colours
p + labs(y = "Probability") + stat_ecdf(aes(colour = k)) +
scale_color_brewer(palette = "Set2")

# Delta Area
p <- graph_delta_area(CC1)

# Heatmaps with column side colours corresponding to clusters
CC2 <- consensus_cluster(x, nk = 3, reps = 3, algorithms = "hc", progress =
FALSE)
graph_heatmap(CC2)

# Track how cluster assignments change between algorithms
p <- graph_tracking(CC1)
}
\author{
Derek Chiu
}
