% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_var_positions}
\alias{create_var_positions}
\title{Create Variable Positions}
\usage{
create_var_positions(cat_c_colors, num_vars)
}
\arguments{
\item{cat_c_colors}{A named vector of colors for variables in category C. The names correspond to variable names.}

\item{num_vars}{The number of variables. Supported values are "3", "4", "5", or "6".}
}
\value{
A data frame with columns:
\describe{
\item{var}{Factor of variable names from \code{cat_c_colors}.}
\item{x_offset}{Numeric x-axis offset for plotting.}
\item{y_offset}{Numeric y-axis offset for plotting.}
}
}
\description{
Generates a data frame containing variable names from \code{cat_c_colors} and corresponding x and y offsets based on the number of variables.
}
\examples{
library(dplyr)
cat_c_colors <- c("Var1" = "red", "Var2" = "blue", "Var3" = "green")
create_var_positions(cat_c_colors, 3)
}
