% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debris_id.R
\name{get_gene_pct}
\alias{get_gene_pct}
\title{Get percent of reads align to given gene(s)}
\usage{
get_gene_pct(x, genes, name)
}
\arguments{
\item{x}{An SCE object.}

\item{genes}{Genes to calculate percentage of in counts.}

\item{name}{Column name to place in dropl_info.}
}
\value{
An SCE object.
}
\description{
Add a data column for each droplet giving the percentage of raw reads/UMIs 
that align to genes given in \code{genes}. The column name is specified by 
\code{name}.
}
\examples{
# Add MT\%
mt_genes <- grep(pattern="^mt-", x=rownames(mb_small@gene_data), ignore.case=TRUE, value=TRUE)
mb_small <- get_gene_pct(x = mb_small, genes=mt_genes, name="pct.mt")
# Add MALAT1
genes <- grep(pattern="^malat1$", x=rownames(mb_small@gene_data), ignore.case=TRUE, value=TRUE)
mb_small <- get_gene_pct(x = mb_small, genes=genes, name="MALAT1")
}
