% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{ddfMLR}
\alias{ddfMLR}
\alias{print.ddfMLR}
\alias{plot.ddfMR}
\alias{print.ddfMLR}
\alias{plot.ddfMLR}
\alias{coef.ddfMLR}
\alias{logLik.ddfMLR}
\alias{AIC.ddfMLR}
\alias{BIC.ddfMLR}
\title{Performs DDF detection using Multinomial Log-linear Regression model.}
\usage{
ddfMLR(Data, group, focal.name, key, type = "both", match = "zscore", anchor = NULL,
purify = FALSE, nrIter = 10, alpha = 0.05, p.adjust.method = "none")

\method{print}{ddfMLR}(x, ...)

\method{plot}{ddfMLR}(x, item = "all", title, ...)

\method{coef}{ddfMLR}(object, ...)

\method{logLik}{ddfMLR}(object, ...)

\method{AIC}{ddfMLR}(object, ...)

\method{BIC}{ddfMLR}(object, ...)
}
\arguments{
\item{Data}{character: either the unscored data matrix only, or the unscored data
matrix plus the vector of group. See \strong{Details}.}

\item{group}{numeric or character: either the binary vector of group membership or
the column indicator of group membership. See \strong{Details}.}

\item{focal.name}{numeric or character: indicates the level of \code{group} which corresponds to
focal group}

\item{key}{character: the answer key. See \strong{Details}.}

\item{type}{character: type of DDF to be tested (either "both" (default), "udif", or "nudif").
See \strong{Details}.}

\item{match}{specifies matching criterion. Can be either \code{"zscore"} (default, standardized total score),
\code{"score"} (total test score), or vector of the same length as number of observations in "Data". See \strong{Details}.}

\item{anchor}{Either \code{NULL} (default) or a vector of item names or item identifiers specifying which items are
currently considered as anchor (DIF free) items. Argument is ignored if \code{match} is not \code{"zscore"} or \code{"score"}.}

\item{purify}{logical: should the item purification be applied? (default is \code{FALSE}). See \strong{Details}.}

\item{nrIter}{numeric: the maximal number of iterations in the item purification (default is 10).}

\item{alpha}{numeric: significance level (default is 0.05).}

\item{p.adjust.method}{character: method for multiple comparison correction.
See \strong{Details}.}

\item{x}{an object of 'ddfMLR' class}

\item{...}{other generic parameters for \code{print} or \code{plot} functions.}

\item{item}{either character ("all"), or numeric vector, or single number
corresponding to column indicators. See \strong{Details}.}

\item{title}{string: title of plot.}

\item{object}{an object of 'ddfMLR' class}
}
\value{
A list of class 'ddfMLR' with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{mlrPAR}}{the estimates of final model.}
  \item{\code{mlrSE}}{standard errors of the estimates of final model.}
  \item{\code{parM0}}{the estimates of null model.}
  \item{\code{parM1}}{the estimates of alternative model.}
  \item{\code{alpha}}{numeric: significance level.}
  \item{\code{DDFitems}}{either the column indicators of the items which were detected as DDF, or \code{"No DDF item detected"}.}
  \item{\code{type}}{character: type of DIF that was tested.}
  \item{\code{purification}}{\code{purify} value.}
  \item{\code{nrPur}}{number of iterations in item purification process. Returned only if \code{purify}
  is \code{TRUE}.}
  \item{\code{difPur}}{a binary matrix with one row per iteration of item purification and one column per item.
  "1" in i-th row and j-th column means that j-th item was identified as DIF in i-1-th iteration. Returned only
  if \code{purify} is \code{TRUE}.}
  \item{\code{conv.puri}}{logical indicating whether item purification process converged before the maximal number
  \code{nrIter} of iterations. Returned only if \code{purify} is \code{TRUE}.}
  \item{\code{p.adjust.method}}{character: method for multiple comparison correction which was applied.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{group}}{the vector of group membership.}
  \item{\code{Data}}{the data matrix.}
  \item{\code{match}}{matching criterion.}
  \item{\code{llM0}}{log-likelihood of null model.}
  \item{\code{llM1}}{log-likelihood of alternative model.}
  \item{\code{AICM0}}{AIC of null model.}
  \item{\code{AICM1}}{AIC of alternative model.}
  \item{\code{BICM0}}{BIC of null model.}
  \item{\code{BICM1}}{BIC of alternative model.}
  }
}
\description{
Performs DDF detection procedure based on Multinomial Log-linear Regression model and
likelihood ratio test of submodel.
}
\details{
DDF detection procedure based on Multinomial Log-linear model.

The \code{Data} is a matrix whose rows represents examinee unscored answers and
columns correspond to the items. The \code{group} must be either a vector of the same
length as \code{nrow(data)} or column indicator of \code{Data}. The \code{key} must be
a vector of correct answers corresponding to columns of \code{Data}.

The \code{type} corresponds to type of DDF to be tested. Possible values are \code{"both"}
to detect any DDF (uniform and/or non-uniform), \code{"udif"} to detect only uniform DDF or
\code{"nudif"} to detect only non-uniform DDF.

Argument \code{match} represents the matching criterion. It can be either the standardized test score (default, \code{"zscore"}),
total test score (\code{"score"}), or any other continuous or discrete variable of the same length as number of observations
in \code{Data}. Matching criterion is used in \code{MLR()} function as a covariate in multinomial model.

A set of anchor items (DIF free) can be specified through the \code{anchor} argument. It need to be a vector of either
item names (as specified in column names of \code{Data}) or item identifiers (integers specifying the column number).
In case anchor items are provided, only these items are used to compute matching criterion \code{match}. If the \code{match}
argument is not either \code{"zscore"} or \code{"score"}, \code{anchor} argument is ignored.  When anchor items are
provided, purification is not applied.

The \code{p.adjust.method} is a character for \code{p.adjust} function from the
\code{stats} package. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.

The output of the ddfMLR is displayed by the \code{print.ddfMLR} function.

The characteristic curve for item specified in \code{item} option can be plotted. For default
option \code{"all"} of item, characteristic curves of all converged items are plotted.
The drawn curves represent best model.

Missing values are allowed but discarded for item estimation. They must be coded as \code{NA}
for both, \code{data} and \code{group} parameters.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMATtest, GMATkey)

Data  <- GMATtest[, 1:20]
group <- GMATtest[, "group"]
key <- GMATkey

# Testing both DDF effects
(x <- ddfMLR(Data, group, focal.name = 1, key))

# Testing both DDF effects with Benjamini-Hochberg adjustment method
ddfMLR(Data, group, focal.name = 1, key, p.adjust.method = "BH")

# Testing both DDF effects with item purification
ddfMLR(Data, group, focal.name = 1, key, purify = T)

# Testing uniform DDF effects
ddfMLR(Data, group, focal.name = 1, key, type = "udif")
# Testing non-uniform DDF effects
ddfMLR(Data, group, focal.name = 1, key, type = "nudif")

# Testing both DDF effects with total score as matching criterion
ddfMLR(Data, group, focal.name = 1, key, match = "score")

# Graphical devices
plot(x, item = 1)
plot(x, item = x$DDFitems)
plot(x, item = "all")

# AIC, BIC, logLik
AIC(x)
BIC(x)
logLik(x)
}
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
}
\keyword{DDF}
