% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulaNLR.R
\name{formulaNLR}
\alias{formulaNLR}
\title{Formula for Non-Linear Regression DIF model.}
\usage{
formulaNLR(model, constraints = NULL, type = "both", parameterization = "classic",
outcome)
}
\arguments{
\item{model}{character: generalized logistic regression model to be fitted. See \strong{Details}.}

\item{constraints}{character: which parameters should be the same for both groups. Default value is \code{NULL}. See \strong{Details}.}

\item{type}{character: type of DIF to be tested. Possible values are "both" (default), "udif", "nudif", "all",
or combination of parameters 'a', 'b', 'c' and 'd'. See \strong{Details}.}

\item{parameterization}{character: which parameterization should be used. Possible values are "classic" (default)
and "alternative". See \strong{Details}.}

\item{outcome}{character: name of outcome to be printed in formula. If not specified 'y' is used.}
}
\value{
A list of two models. Both includes formula, parameters to be estimated and their lower and upper constraints.
}
\description{
Function returns the formula of the non-linear
models based on model specification and DIF type to be tested.
}
\details{
The unconstrained form of 4PL generalized logistic regression model for probability of correct answer (i.e., y = 1) is
P(y = 1) = (c + cDif*g) + (d + dDif*g - c - cDif*g)/(1 + exp(-(a + aDif*g)*(x - b - bDif*g))),
where x is standardized total score (also called Z-score) and g is group membership. Parameters a, b, c and d
are discrimination, difficulty, guessing and inattention. Parameters aDif, bDif, cDif and dDif
then represetn differences between two groups in discrimination, difficulty, guessing and inattention.

This 4PL model can be further constrained by \code{model} and \code{constraints} arguments.
The arguments \code{model} and \code{constraints} can be also combined.

The \code{model} argument offers several predefined models. The options are as follows:
\code{Rasch} for 1PL model with discrimination parameter fixed on value 1 for both groups,
\code{1PL} for 1PL model with discrimination parameter fixed for both groups,
\code{2PL} for logistic regression model,
\code{3PLcg} for 3PL model with fixed guessing for both groups,
\code{3PLdg} for 3PL model with fixed inattention for both groups,
\code{3PLc} (alternatively also \code{3PL}) for 3PL regression model with guessing parameter,
\code{3PLd} for 3PL model with inattention parameter,
\code{4PLcgdg} for 4PL model with fixed guessing and inattention parameter for both groups,
\code{4PLcgd} (alternatively also \code{4PLd}) for 4PL model with fixed guessing for both groups,
\code{4PLcdg} (alternatively also \code{4PLc}) for 4PL model with fixed inattention for both groups,
or \code{4PL} for 4PL model.

The \code{model} can be specified in more detail with \code{constraints} argument which specifies what
arguments should be fixed for both groups. For example, choice 'ad' means that discrimination (a) and
inattention (d) are fixed for both groups and other parameters (b and c) are not.

The \code{type} corresponds to type of DIF to be tested. Possible values are
\code{"both"} to detect any DIF caused by difference in difficulty or discrimination (i.e., uniform and/or non-uniform),
\code{"udif"} to detect only uniform DIF (i.e., difference in difficulty b),
\code{"nudif"} to detect only non-uniform DIF (i.e., difference in discrimination a), or
\code{"all"} to detect DIF caused by difference caused by any parameter that can differed between groups. The \code{type}
of DIF can be also specified in more detail by using combination of parameters a, b, c and d. For example, with an option
'c' for 4PL model only the difference in parameter c is tested.

For an option "alternative" in \code{parameterization} argument, all models with the different guessing or/and inattention
parameters are reparameterized as follows:
P(y = 1) = (cR*(1-g) + cF*g) + (dR*(1-g) + dF*g - cR*(1-g) - cF*g)/(1 + exp(-(a + aDif*g)*(x - b - bDif*g))).
}
\examples{
\dontrun{
# 3PL model with the same guessing for both groups
# to test both types of DIF
formulaNLR(model = "3PLcg", type = "both")

# 4PL model with the same guessing and inattention
# to test uniform DIF
formulaNLR(model = "4PLcgdg", type = "udif")

# 2PL model to test non-uniform DIF
formulaNLR(model = "2PL", type = "nudif")

# 4PL model to test all possible DIF
# with alternative parameterization
formulaNLR(model = "4PL", type = "all", parameterization = "alternative")

# 4PL model with fixed a and c parameter
# to test difference in b with alternative parameterization
formulaNLR(model = "4PL", constraints = "ac", type = "b", parameterization = "alternative")
}

}
\seealso{
\code{\link[difNLR]{difNLR}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
