% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_diff_prob_matrix.R
\name{get_laplacian}
\alias{get_laplacian}
\alias{getLaplacianMatrix}
\title{Evaluate a Laplacian Matrix}
\usage{
get_laplacian(g, type = "Laplacian", weights = NULL, verbose = TRUE)

getLaplacianMatrix(g, type = "Laplacian", weights = NULL, verbose = TRUE)
}
\arguments{
\item{g}{a network}

\item{type}{the type of Laplacian matrix. default \code{"Laplacian"}, the
combinatorial Laplacian. Other types:
\code{c("Normalized Laplacian", "Quantum Laplacian", "MERW Normalized
  Laplacian")}.
Note that you can type abbreviations, e.g. "L", "N", "Q", "M" for the
respective types (case is ignored). The argument match is done through
\code{\link[strex]{match_arg}}.}

\item{weights}{edge weights, representing the strength/intensity (not the cost!) of each link.
if weights is NULL (the default) and g has an edge attribute called weight, then
it will be used automatically.
If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{verbose}{default \code{TRUE}. If information on the type of Laplacian
or on edge weights should be printed.}
}
\value{
the (`type`) Laplacian matrix of network `g`
}
\description{
Returns a specific Laplacian matrix corresponding to the chosen
dynamics type and network. The available types are:
\describe{
  \item{Laplacian}{for the classical combinatorial Laplacian matrix;
    it governs the diffusion dynamics on the network}
  \item{Normalized Laplacian}{for the Laplacian matrix normalized by degree
    matrix, the so-called classical random walk normalized Laplacian;
    it governs stochastic walks on the network}
  \item{Quantum Laplacian}{for the Laplacian matrix normalized to be
    symmetric; it governs quantum walks on the network}
  \item{MERW normalized Laplacian}{the maximal-entropy random walk (RW)
    normalized Laplacian; it governs stochastic walks on the network,
    in which the random walker moves according to a maximal-entropy RW [1].}
}

The maximum entropy random walk (MERW) chooses the stochastic matrix which
maximizes \eqn{H(S)}, so that the walker can explore every walk of the
same length with equal probability.
Let \eqn{\lambda_N, \phi} be the leading eigenvalue and
corresponding right eigenvector of the adjacency matrix \eqn{A}. Then the
transition matrix corresponding to the discrete-time random walk is
\eqn{\Pi_{ij} = \frac{A_{ij}}{\lambda_N}\frac{\phi_j}{\phi_i}.}
The MERW (normalized) Laplacian is then given by \eqn{I - \Pi}.
Note that we use the notation \eqn{\Pi} and \code{Pi} to avoid confusion
with the abbreviation \code{T} for the logical \code{TRUE}.
}
\references{
[1] Burda, Z., et al. (2009). Phys Rev. Lett. 102 160602(April), 1–4.
   \doi{10.1103/PhysRevLett.102.160602}
}
