# diffusr: network diffusion algorithms in R
#
# Copyright (C) 2016 Simon Dirmeier
#
# This file is part of diffusr.
#
# diffusr is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# diffusr is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with diffusr. If not, see <http://www.gnu.org/licenses/>.


#' diffusr
#'
#' Network diffusion algorithms in R.
#'
#' @author Simon Dirmeier \email{simon.dirmeier@@gmx.de}
#' @name diffusr-package
#'
#' @docType package
#' @keywords package
#'
#' @references
#' Tong, H., Faloutsos, C., & Pan, J. Y. (2006),
#' Fast random walk with restart and its applications.\cr \cr
#' Koehler, S., Bauer, S., Horn, D., & Robinson, P. N. (2008),
#' Walking the interactome for prioritization of candidate disease genes.
#' \emph{The American Journal of Human Genetics}\cr \cr
#' Bonacich, P. (1987),
#' Power and centrality: A family of measures.
#' \emph{American Journal of Sociology}\cr \cr
#' Leiserson, M. D., Vandin, F., Wu, H. T., Dobson, J. R., Eldridge, J. V., Thomas, J. L., ... & Lawrence, M. S. (2015),
#' Pan-cancer network analysis identifies combinations of rare somatic mutations across pathways and protein complexes.
#' \emph{Nature genetics}\cr \cr
#' \url{https://en.wikipedia.org/wiki/Laplacian_matrix} \cr
#' \url{https://en.wikipedia.org/wiki/Heat_equation}
#'
#' @useDynLib diffusr
#' @import Rcpp
NULL
