% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual-diff.R
\name{visual_diff_output}
\alias{visual_diff_output}
\alias{visual_diff_render}
\title{Shiny bindings for \code{visual_diff()}}
\usage{
visual_diff_output(outputId, width = "100\%", height = "400px")

visual_diff_render(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a visual_diff}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Components for use inside a Shiny app.
}
\description{
Use \code{visual_diff_output()} in ui and \code{render_visual_diff(visual_diff(...))}
in the server function.
}
\examples{
if (require("shiny") && interactive()) {
ui <- fluidPage(
  visual_diff_output("diff")
)

server <- function(input, output, session) {
  path1 <- tempfile()
  path2 <- tempfile()
  writeLines(letters, path1)
  writeLines(letters[-13], path2)

  output$diff <- visual_diff_render(visual_diff(path1, path2))
}

shinyApp(ui, server)
}
}
