% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pca.R
\docType{methods}
\name{pca}
\alias{pca}
\alias{pca-method}
\alias{pca,data.frame-method}
\alias{pca,matrix-method}
\title{Principal Components Analysis}
\usage{
pca(object, ...)

\S4method{pca}{data.frame}(
  object,
  center = TRUE,
  scale = TRUE,
  rank = NULL,
  sup_row = NULL,
  sup_col = NULL,
  sup_quali = NULL,
  weight_row = NULL,
  weight_col = NULL,
  autodetect = FALSE
)

\S4method{pca}{matrix}(
  object,
  center = TRUE,
  scale = TRUE,
  rank = NULL,
  sup_row = NULL,
  sup_col = NULL,
  weight_row = NULL,
  weight_col = NULL
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{center}{A \code{\link{logical}} scalar: should the variables be shifted to be
zero centered?}

\item{scale}{A \code{\link{logical}} scalar: should the variables be scaled to unit
variance?}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of components
to be kept in the results. If \code{NULL} (the default), \eqn{p - 1} components
will be returned.}

\item{sup_row}{A \code{vector} specifying the indices of the supplementary rows.}

\item{sup_col}{A \code{vector} specifying the indices of the supplementary columns.}

\item{sup_quali}{A \code{vector} specifying the indices of the supplementary
qualitative columns.}

\item{weight_row}{A \code{\link{numeric}} vector specifying the active row (individual)
weights. If \code{NULL} (the default), uniform weights are used. Row weights are
internally normalized to sum 1}

\item{weight_col}{A \code{\link{numeric}} vector specifying the active column
(variable) weights. If \code{NULL} (the default), uniform weights (1) are
used.}

\item{autodetect}{A \code{\link{logical}} scalar: should non-numeric variables be
automatically removed (except \code{sup_quali})?}
}
\value{
A \code{\linkS4class{PCA}} object.
}
\description{
Computes a principal components analysis based on the singular value
decomposition.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, sup_quali = "Species")

## Get eigenvalues
get_eigenvalues(X)

## Get individual cos2
head(get_cos2(X, margin = 1))

## Get variable contributions
get_contributions(X, margin = 2)

## Get correlations between variables and dimensions
get_correlations(X)
}
\references{
Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.
}
\seealso{
\code{\link[=svd]{svd()}}

Other multivariate analysis: 
\code{\link{ca}()},
\code{\link{mca}()},
\code{\link{pcoa}()},
\code{\link{predict}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
